import { Command as $Command } from "@aws-sdk/smithy-client";
import { Handler, HttpHandlerOptions as __HttpHandlerOptions, MetadataBearer as __MetadataBearer, MiddlewareStack } from "@aws-sdk/types";
import { EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../EC2Client";
import { CreateRouteTableRequest, CreateRouteTableResult } from "../models/models_1";
export interface CreateRouteTableCommandInput extends CreateRouteTableRequest {
}
export interface CreateRouteTableCommandOutput extends CreateRouteTableResult, __MetadataBearer {
}

export declare class CreateRouteTableCommand extends $Command<CreateRouteTableCommandInput, CreateRouteTableCommandOutput, EC2ClientResolvedConfig> {
    readonly input: CreateRouteTableCommandInput;
    constructor(input: CreateRouteTableCommandInput);
    
    resolveMiddleware(clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>, configuration: EC2ClientResolvedConfig, options?: __HttpHandlerOptions): Handler<CreateRouteTableCommandInput, CreateRouteTableCommandOutput>;
    private serialize;
    private deserialize;
}
