import { Command as $Command } from "@aws-sdk/smithy-client";
import { Handler, HttpHandlerOptions as __HttpHandlerOptions, MetadataBearer as __MetadataBearer, MiddlewareStack } from "@aws-sdk/types";
import { EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../EC2Client";
import { CreateIpamPoolRequest, CreateIpamPoolResult } from "../models/models_1";
export interface CreateIpamPoolCommandInput extends CreateIpamPoolRequest {
}
export interface CreateIpamPoolCommandOutput extends CreateIpamPoolResult, __MetadataBearer {
}

export declare class CreateIpamPoolCommand extends $Command<CreateIpamPoolCommandInput, CreateIpamPoolCommandOutput, EC2ClientResolvedConfig> {
    readonly input: CreateIpamPoolCommandInput;
    constructor(input: CreateIpamPoolCommandInput);
    
    resolveMiddleware(clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>, configuration: EC2ClientResolvedConfig, options?: __HttpHandlerOptions): Handler<CreateIpamPoolCommandInput, CreateIpamPoolCommandOutput>;
    private serialize;
    private deserialize;
}
