import { Command as $Command } from "@aws-sdk/smithy-client";
import { Handler, HttpHandlerOptions as __HttpHandlerOptions, MetadataBearer as __MetadataBearer, MiddlewareStack } from "@aws-sdk/types";
import { EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../EC2Client";
import { CreateInternetGatewayRequest, CreateInternetGatewayResult } from "../models/models_1";
export interface CreateInternetGatewayCommandInput extends CreateInternetGatewayRequest {
}
export interface CreateInternetGatewayCommandOutput extends CreateInternetGatewayResult, __MetadataBearer {
}

export declare class CreateInternetGatewayCommand extends $Command<CreateInternetGatewayCommandInput, CreateInternetGatewayCommandOutput, EC2ClientResolvedConfig> {
    readonly input: CreateInternetGatewayCommandInput;
    constructor(input: CreateInternetGatewayCommandInput);
    
    resolveMiddleware(clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>, configuration: EC2ClientResolvedConfig, options?: __HttpHandlerOptions): Handler<CreateInternetGatewayCommandInput, CreateInternetGatewayCommandOutput>;
    private serialize;
    private deserialize;
}
