import { Command as $Command } from "@aws-sdk/smithy-client";
import { Handler, HttpHandlerOptions as __HttpHandlerOptions, MetadataBearer as __MetadataBearer, MiddlewareStack } from "@aws-sdk/types";
import { EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../EC2Client";
import { CreateFpgaImageRequest, CreateFpgaImageResult } from "../models/models_1";
export interface CreateFpgaImageCommandInput extends CreateFpgaImageRequest {
}
export interface CreateFpgaImageCommandOutput extends CreateFpgaImageResult, __MetadataBearer {
}

export declare class CreateFpgaImageCommand extends $Command<CreateFpgaImageCommandInput, CreateFpgaImageCommandOutput, EC2ClientResolvedConfig> {
    readonly input: CreateFpgaImageCommandInput;
    constructor(input: CreateFpgaImageCommandInput);
    
    resolveMiddleware(clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>, configuration: EC2ClientResolvedConfig, options?: __HttpHandlerOptions): Handler<CreateFpgaImageCommandInput, CreateFpgaImageCommandOutput>;
    private serialize;
    private deserialize;
}
