import { Command as $Command } from "@aws-sdk/smithy-client";
import { Handler, HttpHandlerOptions as __HttpHandlerOptions, MetadataBearer as __MetadataBearer, MiddlewareStack } from "@aws-sdk/types";
import { EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../EC2Client";
import { CreateCustomerGatewayRequest, CreateCustomerGatewayResult } from "../models/models_0";
export interface CreateCustomerGatewayCommandInput extends CreateCustomerGatewayRequest {
}
export interface CreateCustomerGatewayCommandOutput extends CreateCustomerGatewayResult, __MetadataBearer {
}

export declare class CreateCustomerGatewayCommand extends $Command<CreateCustomerGatewayCommandInput, CreateCustomerGatewayCommandOutput, EC2ClientResolvedConfig> {
    readonly input: CreateCustomerGatewayCommandInput;
    constructor(input: CreateCustomerGatewayCommandInput);
    
    resolveMiddleware(clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>, configuration: EC2ClientResolvedConfig, options?: __HttpHandlerOptions): Handler<CreateCustomerGatewayCommandInput, CreateCustomerGatewayCommandOutput>;
    private serialize;
    private deserialize;
}
