import { Command as $Command } from "@aws-sdk/smithy-client";
import { Handler, HttpHandlerOptions as __HttpHandlerOptions, MetadataBearer as __MetadataBearer, MiddlewareStack } from "@aws-sdk/types";
import { EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../EC2Client";
import { BundleInstanceRequest, BundleInstanceResult } from "../models/models_0";
export interface BundleInstanceCommandInput extends BundleInstanceRequest {
}
export interface BundleInstanceCommandOutput extends BundleInstanceResult, __MetadataBearer {
}

export declare class BundleInstanceCommand extends $Command<BundleInstanceCommandInput, BundleInstanceCommandOutput, EC2ClientResolvedConfig> {
    readonly input: BundleInstanceCommandInput;
    constructor(input: BundleInstanceCommandInput);
    
    resolveMiddleware(clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>, configuration: EC2ClientResolvedConfig, options?: __HttpHandlerOptions): Handler<BundleInstanceCommandInput, BundleInstanceCommandOutput>;
    private serialize;
    private deserialize;
}
