import { AccountAttribute, AccountAttributeName, Address, AddressAttribute, AddressAttributeName, ApplianceModeSupportValue, AssociationStatus, BundleTask, ByoipCidr, CapacityReservation, CapacityReservationFleetState, CarrierGateway, ClientVpnAuthenticationType, ClientVpnAuthorizationRuleStatus, ClientVpnEndpointStatus, ClientVpnRouteStatus, DnsSupportValue, FleetCapacityReservation, FleetCapacityReservationTenancy, FleetInstanceMatchCriteria, GatewayType, InstanceEventWindowState, Ipv6SupportValue, Tag, TagSpecification, Tenancy, TransitGatewayAttachmentResourceType, TransitGatewayPeeringAttachment, TransitGatewayVpcAttachment, TransportProtocol, UnsuccessfulItem, VolumeAttachment, Vpc, VpcAttachment, VpcPeeringConnection } from "./models_0";
import { DiskImageFormat, GroupIdentifier, Ipam, IpamPool, IpamScope, LaunchTemplate, LocalGatewayRoute, LocalGatewayRouteTableVpcAssociation, ManagedPrefixList, PlatformValues, ProtocolValue, SubnetCidrReservation, TransitGateway, TransitGatewayAttachmentBgpConfiguration, TransitGatewayConnect, VolumeType } from "./models_1";
/**
 * <p>Describes the Connect peer details.</p>
 */
export interface TransitGatewayConnectPeerConfiguration {
    /**
     * <p>The Connect peer IP address on the transit gateway side of the tunnel.</p>
     */
    TransitGatewayAddress?: string;
    /**
     * <p>The Connect peer IP address on the appliance side of the tunnel.</p>
     */
    PeerAddress?: string;
    /**
     * <p>The range of interior BGP peer IP addresses.</p>
     */
    InsideCidrBlocks?: string[];
    /**
     * <p>The tunnel protocol.</p>
     */
    Protocol?: ProtocolValue | string;
    /**
     * <p>The BGP configuration details.</p>
     */
    BgpConfigurations?: TransitGatewayAttachmentBgpConfiguration[];
}
export declare namespace TransitGatewayConnectPeerConfiguration {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: TransitGatewayConnectPeerConfiguration) => any;
}
export declare type TransitGatewayConnectPeerState = "available" | "deleted" | "deleting" | "pending";
/**
 * <p>Describes a transit gateway Connect peer.</p>
 */
export interface TransitGatewayConnectPeer {
    /**
     * <p>The ID of the Connect attachment.</p>
     */
    TransitGatewayAttachmentId?: string;
    /**
     * <p>The ID of the Connect peer.</p>
     */
    TransitGatewayConnectPeerId?: string;
    /**
     * <p>The state of the Connect peer.</p>
     */
    State?: TransitGatewayConnectPeerState | string;
    /**
     * <p>The creation time.</p>
     */
    CreationTime?: Date;
    /**
     * <p>The Connect peer details.</p>
     */
    ConnectPeerConfiguration?: TransitGatewayConnectPeerConfiguration;
    /**
     * <p>The tags for the Connect peer.</p>
     */
    Tags?: Tag[];
}
export declare namespace TransitGatewayConnectPeer {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: TransitGatewayConnectPeer) => any;
}
export interface CreateTransitGatewayConnectPeerResult {
    /**
     * <p>Information about the Connect peer.</p>
     */
    TransitGatewayConnectPeer?: TransitGatewayConnectPeer;
}
export declare namespace CreateTransitGatewayConnectPeerResult {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: CreateTransitGatewayConnectPeerResult) => any;
}
export declare type AutoAcceptSharedAssociationsValue = "disable" | "enable";
export declare type Igmpv2SupportValue = "disable" | "enable";
export declare type StaticSourcesSupportValue = "disable" | "enable";
/**
 * <p>The options for the transit gateway multicast domain.</p>
 */
export interface CreateTransitGatewayMulticastDomainRequestOptions {
    /**
     * <p>Specify whether to enable Internet Group Management Protocol (IGMP) version 2 for the transit gateway multicast domain.</p>
     */
    Igmpv2Support?: Igmpv2SupportValue | string;
    /**
     * <p>Specify whether to enable support for statically configuring multicast group sources for a domain.</p>
     */
    StaticSourcesSupport?: StaticSourcesSupportValue | string;
    /**
     * <p>Indicates whether to automatically accept cross-account subnet associations that are associated with the transit gateway multicast domain.</p>
     */
    AutoAcceptSharedAssociations?: AutoAcceptSharedAssociationsValue | string;
}
export declare namespace CreateTransitGatewayMulticastDomainRequestOptions {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: CreateTransitGatewayMulticastDomainRequestOptions) => any;
}
export interface CreateTransitGatewayMulticastDomainRequest {
    /**
     * <p>The ID of the transit gateway.</p>
     */
    TransitGatewayId: string | undefined;
    /**
     * <p>The options for the transit gateway multicast domain.</p>
     */
    Options?: CreateTransitGatewayMulticastDomainRequestOptions;
    /**
     * <p>The tags for the transit gateway multicast domain.</p>
     */
    TagSpecifications?: TagSpecification[];
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
}
export declare namespace CreateTransitGatewayMulticastDomainRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: CreateTransitGatewayMulticastDomainRequest) => any;
}
/**
 * <p>Describes the options for a transit gateway multicast domain.</p>
 */
export interface TransitGatewayMulticastDomainOptions {
    /**
     * <p>Indicates whether Internet Group Management Protocol (IGMP) version 2 is turned on for the transit gateway multicast domain.</p>
     */
    Igmpv2Support?: Igmpv2SupportValue | string;
    /**
     * <p>Indicates whether support for statically configuring transit gateway multicast group sources is turned on.</p>
     */
    StaticSourcesSupport?: StaticSourcesSupportValue | string;
    /**
     * <p>Indicates whether to automatically cross-account subnet associations that are associated with the transit gateway multicast domain.</p>
     */
    AutoAcceptSharedAssociations?: AutoAcceptSharedAssociationsValue | string;
}
export declare namespace TransitGatewayMulticastDomainOptions {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: TransitGatewayMulticastDomainOptions) => any;
}
export declare type TransitGatewayMulticastDomainState = "available" | "deleted" | "deleting" | "pending";
/**
 * <p>Describes the transit gateway multicast domain.</p>
 */
export interface TransitGatewayMulticastDomain {
    /**
     * <p>The ID of the transit gateway multicast domain.</p>
     */
    TransitGatewayMulticastDomainId?: string;
    /**
     * <p>The ID of the transit gateway.</p>
     */
    TransitGatewayId?: string;
    /**
     * <p>The Amazon Resource Name (ARN) of the transit gateway multicast domain.</p>
     */
    TransitGatewayMulticastDomainArn?: string;
    /**
     * <p> The ID of the Amazon Web Services account that owns the transit gateway multicast domain.</p>
     */
    OwnerId?: string;
    /**
     * <p>The options for the transit gateway multicast domain.</p>
     */
    Options?: TransitGatewayMulticastDomainOptions;
    /**
     * <p>The state of the transit gateway multicast domain.</p>
     */
    State?: TransitGatewayMulticastDomainState | string;
    /**
     * <p>The time the transit gateway multicast domain was created.</p>
     */
    CreationTime?: Date;
    /**
     * <p>The tags for the transit gateway multicast domain.</p>
     */
    Tags?: Tag[];
}
export declare namespace TransitGatewayMulticastDomain {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: TransitGatewayMulticastDomain) => any;
}
export interface CreateTransitGatewayMulticastDomainResult {
    /**
     * <p>Information about the transit gateway multicast domain.</p>
     */
    TransitGatewayMulticastDomain?: TransitGatewayMulticastDomain;
}
export declare namespace CreateTransitGatewayMulticastDomainResult {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: CreateTransitGatewayMulticastDomainResult) => any;
}
export interface CreateTransitGatewayPeeringAttachmentRequest {
    /**
     * <p>The ID of the transit gateway.</p>
     */
    TransitGatewayId: string | undefined;
    /**
     * <p>The ID of the peer transit gateway with which to create the peering attachment.</p>
     */
    PeerTransitGatewayId: string | undefined;
    /**
     * <p>The ID of the Amazon Web Services account that owns the peer transit gateway.</p>
     */
    PeerAccountId: string | undefined;
    /**
     * <p>The Region where the peer transit gateway is located.</p>
     */
    PeerRegion: string | undefined;
    /**
     * <p>The tags to apply to the transit gateway peering attachment.</p>
     */
    TagSpecifications?: TagSpecification[];
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
}
export declare namespace CreateTransitGatewayPeeringAttachmentRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: CreateTransitGatewayPeeringAttachmentRequest) => any;
}
export interface CreateTransitGatewayPeeringAttachmentResult {
    /**
     * <p>The transit gateway peering attachment.</p>
     */
    TransitGatewayPeeringAttachment?: TransitGatewayPeeringAttachment;
}
export declare namespace CreateTransitGatewayPeeringAttachmentResult {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: CreateTransitGatewayPeeringAttachmentResult) => any;
}
export interface CreateTransitGatewayPrefixListReferenceRequest {
    /**
     * <p>The ID of the transit gateway route table.</p>
     */
    TransitGatewayRouteTableId: string | undefined;
    /**
     * <p>The ID of the prefix list that is used for destination matches.</p>
     */
    PrefixListId: string | undefined;
    /**
     * <p>The ID of the attachment to which traffic is routed.</p>
     */
    TransitGatewayAttachmentId?: string;
    /**
     * <p>Indicates whether to drop traffic that matches this route.</p>
     */
    Blackhole?: boolean;
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
}
export declare namespace CreateTransitGatewayPrefixListReferenceRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: CreateTransitGatewayPrefixListReferenceRequest) => any;
}
export declare type TransitGatewayPrefixListReferenceState = "available" | "deleting" | "modifying" | "pending";
/**
 * <p>Describes a transit gateway prefix list attachment.</p>
 */
export interface TransitGatewayPrefixListAttachment {
    /**
     * <p>The ID of the attachment.</p>
     */
    TransitGatewayAttachmentId?: string;
    /**
     * <p>The resource type. Note that the <code>tgw-peering</code> resource type has been deprecated.</p>
     */
    ResourceType?: TransitGatewayAttachmentResourceType | string;
    /**
     * <p>The ID of the resource.</p>
     */
    ResourceId?: string;
}
export declare namespace TransitGatewayPrefixListAttachment {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: TransitGatewayPrefixListAttachment) => any;
}
/**
 * <p>Describes a prefix list reference.</p>
 */
export interface TransitGatewayPrefixListReference {
    /**
     * <p>The ID of the transit gateway route table.</p>
     */
    TransitGatewayRouteTableId?: string;
    /**
     * <p>The ID of the prefix list.</p>
     */
    PrefixListId?: string;
    /**
     * <p>The ID of the prefix list owner.</p>
     */
    PrefixListOwnerId?: string;
    /**
     * <p>The state of the prefix list reference.</p>
     */
    State?: TransitGatewayPrefixListReferenceState | string;
    /**
     * <p>Indicates whether traffic that matches this route is dropped.</p>
     */
    Blackhole?: boolean;
    /**
     * <p>Information about the transit gateway attachment.</p>
     */
    TransitGatewayAttachment?: TransitGatewayPrefixListAttachment;
}
export declare namespace TransitGatewayPrefixListReference {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: TransitGatewayPrefixListReference) => any;
}
export interface CreateTransitGatewayPrefixListReferenceResult {
    /**
     * <p>Information about the prefix list reference.</p>
     */
    TransitGatewayPrefixListReference?: TransitGatewayPrefixListReference;
}
export declare namespace CreateTransitGatewayPrefixListReferenceResult {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: CreateTransitGatewayPrefixListReferenceResult) => any;
}
export interface CreateTransitGatewayRouteRequest {
    /**
     * <p>The CIDR range used for destination matches. Routing decisions are based on the
     *          most specific match.</p>
     */
    DestinationCidrBlock: string | undefined;
    /**
     * <p>The ID of the transit gateway route table.</p>
     */
    TransitGatewayRouteTableId: string | undefined;
    /**
     * <p>The ID of the attachment.</p>
     */
    TransitGatewayAttachmentId?: string;
    /**
     * <p>Indicates whether to drop traffic that matches this route.</p>
     */
    Blackhole?: boolean;
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
}
export declare namespace CreateTransitGatewayRouteRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: CreateTransitGatewayRouteRequest) => any;
}
export declare type TransitGatewayRouteState = "active" | "blackhole" | "deleted" | "deleting" | "pending";
/**
 * <p>Describes a route attachment.</p>
 */
export interface TransitGatewayRouteAttachment {
    /**
     * <p>The ID of the resource.</p>
     */
    ResourceId?: string;
    /**
     * <p>The ID of the attachment.</p>
     */
    TransitGatewayAttachmentId?: string;
    /**
     * <p>The resource type. Note that the <code>tgw-peering</code> resource type has been deprecated. </p>
     */
    ResourceType?: TransitGatewayAttachmentResourceType | string;
}
export declare namespace TransitGatewayRouteAttachment {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: TransitGatewayRouteAttachment) => any;
}
export declare type TransitGatewayRouteType = "propagated" | "static";
/**
 * <p>Describes a route for a transit gateway route table.</p>
 */
export interface TransitGatewayRoute {
    /**
     * <p>The CIDR block used for destination matches.</p>
     */
    DestinationCidrBlock?: string;
    /**
     * <p>The ID of the prefix list used for destination matches.</p>
     */
    PrefixListId?: string;
    /**
     * <p>The attachments.</p>
     */
    TransitGatewayAttachments?: TransitGatewayRouteAttachment[];
    /**
     * <p>The route type.</p>
     */
    Type?: TransitGatewayRouteType | string;
    /**
     * <p>The state of the route.</p>
     */
    State?: TransitGatewayRouteState | string;
}
export declare namespace TransitGatewayRoute {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: TransitGatewayRoute) => any;
}
export interface CreateTransitGatewayRouteResult {
    /**
     * <p>Information about the route.</p>
     */
    Route?: TransitGatewayRoute;
}
export declare namespace CreateTransitGatewayRouteResult {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: CreateTransitGatewayRouteResult) => any;
}
export interface CreateTransitGatewayRouteTableRequest {
    /**
     * <p>The ID of the transit gateway.</p>
     */
    TransitGatewayId: string | undefined;
    /**
     * <p>The tags to apply to the transit gateway route table.</p>
     */
    TagSpecifications?: TagSpecification[];
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
}
export declare namespace CreateTransitGatewayRouteTableRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: CreateTransitGatewayRouteTableRequest) => any;
}
export declare type TransitGatewayRouteTableState = "available" | "deleted" | "deleting" | "pending";
/**
 * <p>Describes a transit gateway route table.</p>
 */
export interface TransitGatewayRouteTable {
    /**
     * <p>The ID of the transit gateway route table.</p>
     */
    TransitGatewayRouteTableId?: string;
    /**
     * <p>The ID of the transit gateway.</p>
     */
    TransitGatewayId?: string;
    /**
     * <p>The state of the transit gateway route table.</p>
     */
    State?: TransitGatewayRouteTableState | string;
    /**
     * <p>Indicates whether this is the default association route table for the transit gateway.</p>
     */
    DefaultAssociationRouteTable?: boolean;
    /**
     * <p>Indicates whether this is the default propagation route table for the transit gateway.</p>
     */
    DefaultPropagationRouteTable?: boolean;
    /**
     * <p>The creation time.</p>
     */
    CreationTime?: Date;
    /**
     * <p>Any tags assigned to the route table.</p>
     */
    Tags?: Tag[];
}
export declare namespace TransitGatewayRouteTable {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: TransitGatewayRouteTable) => any;
}
export interface CreateTransitGatewayRouteTableResult {
    /**
     * <p>Information about the transit gateway route table.</p>
     */
    TransitGatewayRouteTable?: TransitGatewayRouteTable;
}
export declare namespace CreateTransitGatewayRouteTableResult {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: CreateTransitGatewayRouteTableResult) => any;
}
/**
 * <p>Describes the options for a VPC attachment.</p>
 */
export interface CreateTransitGatewayVpcAttachmentRequestOptions {
    /**
     * <p>Enable or disable DNS support. The default is <code>enable</code>.</p>
     */
    DnsSupport?: DnsSupportValue | string;
    /**
     * <p>Enable or disable IPv6 support.  The default is <code>disable</code>.</p>
     */
    Ipv6Support?: Ipv6SupportValue | string;
    /**
     * <p>Enable or disable support for appliance mode. If enabled, a traffic flow between a source and destination uses the same Availability Zone for the VPC attachment for the lifetime of that flow. The default is <code>disable</code>.</p>
     */
    ApplianceModeSupport?: ApplianceModeSupportValue | string;
}
export declare namespace CreateTransitGatewayVpcAttachmentRequestOptions {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: CreateTransitGatewayVpcAttachmentRequestOptions) => any;
}
export interface CreateTransitGatewayVpcAttachmentRequest {
    /**
     * <p>The ID of the transit gateway.</p>
     */
    TransitGatewayId: string | undefined;
    /**
     * <p>The ID of the VPC.</p>
     */
    VpcId: string | undefined;
    /**
     * <p>The IDs of one or more subnets. You can specify only one subnet per Availability Zone.
     *          You must specify at least one subnet, but we recommend that you specify two subnets for better availability.
     *          The transit gateway uses one IP address from each specified subnet.</p>
     */
    SubnetIds: string[] | undefined;
    /**
     * <p>The VPC attachment options.</p>
     */
    Options?: CreateTransitGatewayVpcAttachmentRequestOptions;
    /**
     * <p>The tags to apply to the VPC attachment.</p>
     */
    TagSpecifications?: TagSpecification[];
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
}
export declare namespace CreateTransitGatewayVpcAttachmentRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: CreateTransitGatewayVpcAttachmentRequest) => any;
}
export interface CreateTransitGatewayVpcAttachmentResult {
    /**
     * <p>Information about the VPC attachment.</p>
     */
    TransitGatewayVpcAttachment?: TransitGatewayVpcAttachment;
}
export declare namespace CreateTransitGatewayVpcAttachmentResult {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: CreateTransitGatewayVpcAttachmentResult) => any;
}
export interface CreateVolumeRequest {
    /**
     * <p>The Availability Zone in which to create the volume.</p>
     */
    AvailabilityZone: string | undefined;
    /**
     * <p>Indicates whether the volume should be encrypted.
     *       The effect of setting the encryption state to <code>true</code> depends on
     * the volume origin (new or from a snapshot), starting encryption state, ownership, and whether encryption by default is enabled.
     *       For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html#encryption-by-default">Encryption by default</a>
     *       in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>
     *          <p>Encrypted Amazon EBS volumes must be attached to instances that support Amazon EBS encryption.
     *       For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html#EBSEncryption_supported_instances">Supported
     *         instance types</a>.</p>
     */
    Encrypted?: boolean;
    /**
     * <p>The number of I/O operations per second (IOPS). For <code>gp3</code>, <code>io1</code>, and <code>io2</code> volumes, this represents
     *       the number of IOPS that are provisioned for the volume. For <code>gp2</code> volumes, this represents the baseline
     *       performance of the volume and the rate at which the volume accumulates I/O credits for bursting.</p>
     *          <p>The following are the supported values for each volume type:</p>
     *          <ul>
     *             <li>
     *                <p>
     *                   <code>gp3</code>: 3,000-16,000 IOPS</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>io1</code>: 100-64,000 IOPS</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>io2</code>: 100-64,000 IOPS</p>
     *             </li>
     *          </ul>
     *          <p>
     *             <code>io1</code> and <code>io2</code> volumes support up to 64,000 IOPS only on
     *       <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html#ec2-nitro-instances">Instances built on the Nitro System</a>. Other instance families support performance
     *       up to 32,000 IOPS.</p>
     *          <p>This parameter is required for <code>io1</code> and <code>io2</code> volumes.
     *       The default for <code>gp3</code> volumes is 3,000 IOPS.
     *       This parameter is not supported for <code>gp2</code>, <code>st1</code>, <code>sc1</code>, or <code>standard</code> volumes.</p>
     */
    Iops?: number;
    /**
     * <p>The identifier of the Key Management Service (KMS) KMS key to use for Amazon EBS encryption.
     *       If this parameter is not specified, your KMS key for Amazon EBS is used. If <code>KmsKeyId</code> is
     *       specified, the encrypted state must be <code>true</code>.</p>
     *          <p>You can specify the KMS key using any of the following:</p>
     *          <ul>
     *             <li>
     *                <p>Key ID. For example, 1234abcd-12ab-34cd-56ef-1234567890ab.</p>
     *             </li>
     *             <li>
     *                <p>Key alias. For example, alias/ExampleAlias.</p>
     *             </li>
     *             <li>
     *                <p>Key ARN. For example, arn:aws:kms:us-east-1:012345678910:key/1234abcd-12ab-34cd-56ef-1234567890ab.</p>
     *             </li>
     *             <li>
     *                <p>Alias ARN. For example, arn:aws:kms:us-east-1:012345678910:alias/ExampleAlias.</p>
     *             </li>
     *          </ul>
     *          <p>Amazon Web Services authenticates the KMS key asynchronously. Therefore, if you specify an ID, alias, or ARN that is not valid,
     *       the action can appear to complete, but eventually fails.</p>
     */
    KmsKeyId?: string;
    /**
     * <p>The Amazon Resource Name (ARN) of the Outpost.</p>
     */
    OutpostArn?: string;
    /**
     * <p>The size of the volume, in GiBs. You must specify either a snapshot ID or a volume size.
     *       If you specify a snapshot, the default is the snapshot size. You can specify a volume
     *       size that is equal to or larger than the snapshot size.</p>
     *          <p>The following are the supported volumes sizes for each volume type:</p>
     *          <ul>
     *             <li>
     *                <p>
     *                   <code>gp2</code> and <code>gp3</code>: 1-16,384</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>io1</code> and <code>io2</code>: 4-16,384</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>st1</code> and <code>sc1</code>: 125-16,384</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>standard</code>: 1-1,024</p>
     *             </li>
     *          </ul>
     */
    Size?: number;
    /**
     * <p>The snapshot from which to create the volume. You must specify either a snapshot ID or a volume size.</p>
     */
    SnapshotId?: string;
    /**
     * <p>The volume type. This parameter can be one of the following values:</p>
     *          <ul>
     *             <li>
     *                <p>General Purpose SSD: <code>gp2</code> | <code>gp3</code>
     *                </p>
     *             </li>
     *             <li>
     *                <p>Provisioned IOPS SSD: <code>io1</code> | <code>io2</code>
     *                </p>
     *             </li>
     *             <li>
     *                <p>Throughput Optimized HDD: <code>st1</code>
     *                </p>
     *             </li>
     *             <li>
     *                <p>Cold HDD: <code>sc1</code>
     *                </p>
     *             </li>
     *             <li>
     *                <p>Magnetic: <code>standard</code>
     *                </p>
     *             </li>
     *          </ul>
     *          <p>For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSVolumeTypes.html">Amazon EBS volume types</a> in the
     *       <i>Amazon Elastic Compute Cloud User Guide</i>.</p>
     *          <p>Default: <code>gp2</code>
     *          </p>
     */
    VolumeType?: VolumeType | string;
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
    /**
     * <p>The tags to apply to the volume during creation.</p>
     */
    TagSpecifications?: TagSpecification[];
    /**
     * <p>Indicates whether to enable Amazon EBS Multi-Attach. If you enable Multi-Attach, you can attach the
     *     	volume to up to 16 <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html#ec2-nitro-instances">Instances built on the Nitro System</a> in the same Availability Zone. This parameter is
     *     	supported with <code>io1</code> and <code>io2</code> volumes only. For more information,
     *     	see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-volumes-multi.html">
     *     		Amazon EBS Multi-Attach</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p>
     */
    MultiAttachEnabled?: boolean;
    /**
     * <p>The throughput to provision for a volume, with a maximum of 1,000 MiB/s.</p>
     *          <p>This parameter is valid only for <code>gp3</code> volumes.</p>
     *   	      <p>Valid Range: Minimum value of 125. Maximum value of 1000.</p>
     */
    Throughput?: number;
    /**
     * <p>Unique, case-sensitive identifier that you provide to ensure the idempotency
     *       of the request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensure
     *         Idempotency</a>.</p>
     */
    ClientToken?: string;
}
export declare namespace CreateVolumeRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: CreateVolumeRequest) => any;
}
export declare type VolumeState = "available" | "creating" | "deleted" | "deleting" | "error" | "in-use";
/**
 * <p>Describes a volume.</p>
 */
export interface Volume {
    /**
     * <p>Information about the volume attachments.</p>
     */
    Attachments?: VolumeAttachment[];
    /**
     * <p>The Availability Zone for the volume.</p>
     */
    AvailabilityZone?: string;
    /**
     * <p>The time stamp when volume creation was initiated.</p>
     */
    CreateTime?: Date;
    /**
     * <p>Indicates whether the volume is encrypted.</p>
     */
    Encrypted?: boolean;
    /**
     * <p>The Amazon Resource Name (ARN) of the Key Management Service (KMS) KMS key that was used to protect the
     *       volume encryption key for the volume.</p>
     */
    KmsKeyId?: string;
    /**
     * <p>The Amazon Resource Name (ARN) of the Outpost.</p>
     */
    OutpostArn?: string;
    /**
     * <p>The size of the volume, in GiBs.</p>
     */
    Size?: number;
    /**
     * <p>The snapshot from which the volume was created, if applicable.</p>
     */
    SnapshotId?: string;
    /**
     * <p>The volume state.</p>
     */
    State?: VolumeState | string;
    /**
     * <p>The ID of the volume.</p>
     */
    VolumeId?: string;
    /**
     * <p>The number of I/O operations per second (IOPS). For <code>gp3</code>, <code>io1</code>, and <code>io2</code> volumes, this represents
     *       the number of IOPS that are provisioned for the volume. For <code>gp2</code> volumes, this represents the baseline
     *       performance of the volume and the rate at which the volume accumulates I/O credits for bursting.</p>
     */
    Iops?: number;
    /**
     * <p>Any tags assigned to the volume.</p>
     */
    Tags?: Tag[];
    /**
     * <p>The volume type.</p>
     */
    VolumeType?: VolumeType | string;
    /**
     * <p>Indicates whether the volume was created using fast snapshot restore.</p>
     */
    FastRestored?: boolean;
    /**
     * <p>Indicates whether Amazon EBS Multi-Attach is enabled.</p>
     */
    MultiAttachEnabled?: boolean;
    /**
     * <p>The throughput that the volume supports, in MiB/s.</p>
     */
    Throughput?: number;
}
export declare namespace Volume {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: Volume) => any;
}
export interface CreateVpcRequest {
    /**
     * <p>The IPv4 network range for the VPC, in CIDR notation. For example,
     * 		        <code>10.0.0.0/16</code>. We modify the specified CIDR block to its canonical form; for example, if you specify <code>100.68.0.18/18</code>, we modify it to <code>100.68.0.0/18</code>.</p>
     */
    CidrBlock?: string;
    /**
     * <p>Requests an Amazon-provided IPv6 CIDR block with a /56 prefix length for the VPC.
     *             You cannot specify the range of IP addresses, or the size of the CIDR block.</p>
     */
    AmazonProvidedIpv6CidrBlock?: boolean;
    /**
     * <p>The ID of an IPv6 address pool from which to allocate the IPv6 CIDR block.</p>
     */
    Ipv6Pool?: string;
    /**
     * <p>The IPv6 CIDR block from the IPv6 address pool. You must also specify <code>Ipv6Pool</code> in the request.</p>
     *         <p>To let Amazon choose the IPv6 CIDR block for you, omit this parameter.</p>
     */
    Ipv6CidrBlock?: string;
    /**
     * <p>The ID of an IPv4 IPAM pool you want to use for allocating this VPC's CIDR. For more information, see <a href="/vpc/latest/ipam/what-is-it-ipam.html">What is IPAM?</a> in the <i>Amazon VPC IPAM User Guide</i>.
     *
     *       </p>
     */
    Ipv4IpamPoolId?: string;
    /**
     * <p>The netmask length of the IPv4 CIDR you want to allocate to this VPC from an Amazon VPC IP Address Manager (IPAM) pool. For more information about IPAM, see <a href="/vpc/latest/ipam/what-is-it-ipam.html">What is IPAM?</a> in the <i>Amazon VPC IPAM User Guide</i>.</p>
     */
    Ipv4NetmaskLength?: number;
    /**
     * <p>The ID of an IPv6 IPAM pool which will be used to allocate this VPC an IPv6 CIDR. IPAM is a VPC feature that you can use to automate your IP address management workflows including assigning, tracking, troubleshooting, and auditing IP addresses across Amazon Web Services Regions and accounts throughout your Amazon Web Services Organization. For more information, see <a href="/vpc/latest/ipam/what-is-it-ipam.html">What is IPAM?</a> in the <i>Amazon VPC IPAM User Guide</i>.</p>
     */
    Ipv6IpamPoolId?: string;
    /**
     * <p>The netmask length of the IPv6 CIDR you want to allocate to this VPC from an Amazon VPC IP Address Manager (IPAM) pool. For more information about IPAM, see <a href="/vpc/latest/ipam/what-is-it-ipam.html">What is IPAM?</a> in the <i>Amazon VPC IPAM User Guide</i>.</p>
     */
    Ipv6NetmaskLength?: number;
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
    /**
     * <p>The tenancy options for instances launched into the VPC. For <code>default</code>, instances
     *       are launched with shared tenancy by default. You can launch instances with any tenancy into a
     *       shared tenancy VPC. For <code>dedicated</code>, instances are launched as dedicated tenancy
     *       instances by default. You can only launch instances with a tenancy of <code>dedicated</code>
     *       or <code>host</code> into a dedicated tenancy VPC. </p>
     *          <p>
     *             <b>Important:</b> The <code>host</code> value cannot be used with this parameter. Use the <code>default</code> or <code>dedicated</code> values only.</p>
     *          <p>Default: <code>default</code>
     *          </p>
     */
    InstanceTenancy?: Tenancy | string;
    /**
     * <p>The name of the location from which we advertise the IPV6 CIDR block. Use this parameter to limit the address to this location.</p>
     *          <p> You must set <code>AmazonProvidedIpv6CidrBlock</code> to <code>true</code> to use this parameter.</p>
     */
    Ipv6CidrBlockNetworkBorderGroup?: string;
    /**
     * <p>The tags to assign to the VPC.</p>
     */
    TagSpecifications?: TagSpecification[];
}
export declare namespace CreateVpcRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: CreateVpcRequest) => any;
}
export interface CreateVpcResult {
    /**
     * <p>Information about the VPC.</p>
     */
    Vpc?: Vpc;
}
export declare namespace CreateVpcResult {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: CreateVpcResult) => any;
}
export declare enum VpcEndpointType {
    Gateway = "Gateway",
    GatewayLoadBalancer = "GatewayLoadBalancer",
    Interface = "Interface"
}
/**
 * <p>Contains the parameters for CreateVpcEndpoint.</p>
 */
export interface CreateVpcEndpointRequest {
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
    /**
     * <p>The type of endpoint.</p>
     *         <p>Default: Gateway</p>
     */
    VpcEndpointType?: VpcEndpointType | string;
    /**
     * <p>The ID of the VPC in which the endpoint will be used.</p>
     */
    VpcId: string | undefined;
    /**
     * <p>The service name. To get a list of available services, use the <a>DescribeVpcEndpointServices</a> request, or get the name from the service
     *             provider.</p>
     */
    ServiceName: string | undefined;
    /**
     * <p>(Interface and gateway endpoints) A policy to attach to the endpoint that controls access to the
     *             service. The policy must be in valid JSON format. If this parameter is not specified, we
     *             attach a default policy that allows full access to the service.</p>
     */
    PolicyDocument?: string;
    /**
     * <p>(Gateway endpoint) One or more route table IDs.</p>
     */
    RouteTableIds?: string[];
    /**
     * <p>(Interface and Gateway Load Balancer endpoints) The ID of one or more subnets in which to create an endpoint
     *             network interface. For a Gateway Load Balancer endpoint, you can specify one subnet only.</p>
     */
    SubnetIds?: string[];
    /**
     * <p>(Interface endpoint) The ID of one or more security groups to associate with the
     *             endpoint network interface.</p>
     */
    SecurityGroupIds?: string[];
    /**
     * <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the
     *             request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">How to ensure
     *                 idempotency</a>.</p>
     */
    ClientToken?: string;
    /**
     * <p>(Interface endpoint) Indicates whether to associate a private hosted zone with the
     *             specified VPC. The private hosted zone contains a record set for the default public DNS
     *             name for the service for the Region (for example,
     *                 <code>kinesis.us-east-1.amazonaws.com</code>), which resolves to the private IP
     *             addresses of the endpoint network interfaces in the VPC. This enables you to make
     *             requests to the default public DNS name for the service instead of the public DNS names
     *             that are automatically generated by the VPC endpoint service.</p>
     *         <p>To use a private hosted zone, you must set the following VPC attributes to
     *             <code>true</code>: <code>enableDnsHostnames</code> and
     *             <code>enableDnsSupport</code>. Use <a>ModifyVpcAttribute</a> to set the VPC
     *             attributes.</p>
     *         <p>Default: <code>true</code>
     *          </p>
     */
    PrivateDnsEnabled?: boolean;
    /**
     * <p>The tags to associate with the endpoint.</p>
     */
    TagSpecifications?: TagSpecification[];
}
export declare namespace CreateVpcEndpointRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: CreateVpcEndpointRequest) => any;
}
/**
 * <p>Describes a DNS entry.</p>
 */
export interface DnsEntry {
    /**
     * <p>The DNS name.</p>
     */
    DnsName?: string;
    /**
     * <p>The ID of the private hosted zone.</p>
     */
    HostedZoneId?: string;
}
export declare namespace DnsEntry {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DnsEntry) => any;
}
/**
 * <p>Describes a security group.</p>
 */
export interface SecurityGroupIdentifier {
    /**
     * <p>The ID of the security group.</p>
     */
    GroupId?: string;
    /**
     * <p>The name of the security group.</p>
     */
    GroupName?: string;
}
export declare namespace SecurityGroupIdentifier {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: SecurityGroupIdentifier) => any;
}
/**
 * <p>The last error that occurred for a VPC endpoint.</p>
 */
export interface LastError {
    /**
     * <p>The error message for the VPC endpoint error.</p>
     */
    Message?: string;
    /**
     * <p>The error code for the VPC endpoint error.</p>
     */
    Code?: string;
}
export declare namespace LastError {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: LastError) => any;
}
export declare enum State {
    Available = "Available",
    Deleted = "Deleted",
    Deleting = "Deleting",
    Expired = "Expired",
    Failed = "Failed",
    Pending = "Pending",
    PendingAcceptance = "PendingAcceptance",
    Rejected = "Rejected"
}
/**
 * <p>Describes a VPC endpoint.</p>
 */
export interface VpcEndpoint {
    /**
     * <p>The ID of the VPC endpoint.</p>
     */
    VpcEndpointId?: string;
    /**
     * <p>The type of endpoint.</p>
     */
    VpcEndpointType?: VpcEndpointType | string;
    /**
     * <p>The ID of the VPC to which the endpoint is associated.</p>
     */
    VpcId?: string;
    /**
     * <p>The name of the service to which the endpoint is associated.</p>
     */
    ServiceName?: string;
    /**
     * <p>The state of the VPC endpoint.</p>
     */
    State?: State | string;
    /**
     * <p>The policy document associated with the endpoint, if applicable.</p>
     */
    PolicyDocument?: string;
    /**
     * <p>(Gateway endpoint) One or more route tables associated with the endpoint.</p>
     */
    RouteTableIds?: string[];
    /**
     * <p>(Interface endpoint) One or more subnets in which the endpoint is located.</p>
     */
    SubnetIds?: string[];
    /**
     * <p>(Interface endpoint) Information about the security groups that are associated with
     *             the network interface.</p>
     */
    Groups?: SecurityGroupIdentifier[];
    /**
     * <p>(Interface endpoint) Indicates whether the VPC is associated with a private hosted zone.</p>
     */
    PrivateDnsEnabled?: boolean;
    /**
     * <p>Indicates whether the VPC endpoint is being managed by its service.</p>
     */
    RequesterManaged?: boolean;
    /**
     * <p>(Interface endpoint) One or more network interfaces for the endpoint.</p>
     */
    NetworkInterfaceIds?: string[];
    /**
     * <p>(Interface endpoint) The DNS entries for the endpoint.</p>
     */
    DnsEntries?: DnsEntry[];
    /**
     * <p>The date and time that the VPC endpoint was created.</p>
     */
    CreationTimestamp?: Date;
    /**
     * <p>Any tags assigned to the VPC endpoint.</p>
     */
    Tags?: Tag[];
    /**
     * <p>The ID of the Amazon Web Services account that owns the VPC endpoint.</p>
     */
    OwnerId?: string;
    /**
     * <p>The last error that occurred for VPC endpoint.</p>
     */
    LastError?: LastError;
}
export declare namespace VpcEndpoint {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: VpcEndpoint) => any;
}
/**
 * <p>Contains the output of CreateVpcEndpoint.</p>
 */
export interface CreateVpcEndpointResult {
    /**
     * <p>Information about the endpoint.</p>
     */
    VpcEndpoint?: VpcEndpoint;
    /**
     * <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the
     *             request.</p>
     */
    ClientToken?: string;
}
export declare namespace CreateVpcEndpointResult {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: CreateVpcEndpointResult) => any;
}
export interface CreateVpcEndpointConnectionNotificationRequest {
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
    /**
     * <p>The ID of the endpoint service.</p>
     */
    ServiceId?: string;
    /**
     * <p>The ID of the endpoint.</p>
     */
    VpcEndpointId?: string;
    /**
     * <p>The ARN of the SNS topic for the notifications.</p>
     */
    ConnectionNotificationArn: string | undefined;
    /**
     * <p>One or more endpoint events for which to receive notifications. Valid values are
     *                 <code>Accept</code>, <code>Connect</code>, <code>Delete</code>, and
     *                 <code>Reject</code>.</p>
     */
    ConnectionEvents: string[] | undefined;
    /**
     * <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the
     *             request. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">How to ensure
     *                 idempotency</a>.</p>
     */
    ClientToken?: string;
}
export declare namespace CreateVpcEndpointConnectionNotificationRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: CreateVpcEndpointConnectionNotificationRequest) => any;
}
export declare enum ConnectionNotificationState {
    Disabled = "Disabled",
    Enabled = "Enabled"
}
export declare enum ConnectionNotificationType {
    Topic = "Topic"
}
/**
 * <p>Describes a connection notification for a VPC endpoint or VPC endpoint
 *             service.</p>
 */
export interface ConnectionNotification {
    /**
     * <p>The ID of the notification.</p>
     */
    ConnectionNotificationId?: string;
    /**
     * <p>The ID of the endpoint service.</p>
     */
    ServiceId?: string;
    /**
     * <p>The ID of the VPC endpoint.</p>
     */
    VpcEndpointId?: string;
    /**
     * <p>The type of notification.</p>
     */
    ConnectionNotificationType?: ConnectionNotificationType | string;
    /**
     * <p>The ARN of the SNS topic for the notification.</p>
     */
    ConnectionNotificationArn?: string;
    /**
     * <p>The events for the notification. Valid values are <code>Accept</code>,
     *                 <code>Connect</code>, <code>Delete</code>, and <code>Reject</code>.</p>
     */
    ConnectionEvents?: string[];
    /**
     * <p>The state of the notification.</p>
     */
    ConnectionNotificationState?: ConnectionNotificationState | string;
}
export declare namespace ConnectionNotification {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: ConnectionNotification) => any;
}
export interface CreateVpcEndpointConnectionNotificationResult {
    /**
     * <p>Information about the notification.</p>
     */
    ConnectionNotification?: ConnectionNotification;
    /**
     * <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the
     *             request.</p>
     */
    ClientToken?: string;
}
export declare namespace CreateVpcEndpointConnectionNotificationResult {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: CreateVpcEndpointConnectionNotificationResult) => any;
}
export interface CreateVpcEndpointServiceConfigurationRequest {
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
    /**
     * <p>Indicates whether requests from service consumers to create an endpoint to your service must
     *             be accepted. To accept a request, use <a>AcceptVpcEndpointConnections</a>.</p>
     */
    AcceptanceRequired?: boolean;
    /**
     * <p>(Interface endpoint configuration) The private DNS name to assign to the VPC endpoint service.</p>
     */
    PrivateDnsName?: string;
    /**
     * <p>The Amazon Resource Names (ARNs) of one or more Network Load Balancers for your
     *             service.</p>
     */
    NetworkLoadBalancerArns?: string[];
    /**
     * <p>The Amazon Resource Names (ARNs) of one or more Gateway Load Balancers.</p>
     */
    GatewayLoadBalancerArns?: string[];
    /**
     * <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
     *             For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Run_Instance_Idempotency.html">How to ensure
     *                 idempotency</a>.</p>
     */
    ClientToken?: string;
    /**
     * <p>The tags to associate with the service.</p>
     */
    TagSpecifications?: TagSpecification[];
}
export declare namespace CreateVpcEndpointServiceConfigurationRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: CreateVpcEndpointServiceConfigurationRequest) => any;
}
export declare enum DnsNameState {
    Failed = "failed",
    PendingVerification = "pendingVerification",
    Verified = "verified"
}
/**
 * <p>Information about the private DNS name for the service endpoint. For more information
 *             about these parameters, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/ndpoint-services-dns-validation.html">VPC Endpoint Service
 *                 Private DNS Name Verification</a> in the
 *             <i>Amazon Virtual Private Cloud User Guide</i>.</p>
 */
export interface PrivateDnsNameConfiguration {
    /**
     * <p>The verification state of the VPC endpoint service.</p>
     *         <p>>Consumers
     *             of the endpoint service can use the private name only when the state is
     *                 <code>verified</code>.</p>
     */
    State?: DnsNameState | string;
    /**
     * <p>The endpoint service verification type, for example TXT.</p>
     */
    Type?: string;
    /**
     * <p>The value the service provider adds to the private DNS name domain record before verification.</p>
     */
    Value?: string;
    /**
     * <p>The name of the record subdomain the service provider needs to create. The service provider adds the <code>value</code> text to the <code>name</code>.</p>
     */
    Name?: string;
}
export declare namespace PrivateDnsNameConfiguration {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: PrivateDnsNameConfiguration) => any;
}
export declare enum ServiceState {
    Available = "Available",
    Deleted = "Deleted",
    Deleting = "Deleting",
    Failed = "Failed",
    Pending = "Pending"
}
export declare enum ServiceType {
    Gateway = "Gateway",
    GatewayLoadBalancer = "GatewayLoadBalancer",
    Interface = "Interface"
}
/**
 * <p>Describes the type of service for a VPC endpoint.</p>
 */
export interface ServiceTypeDetail {
    /**
     * <p>The type of service.</p>
     */
    ServiceType?: ServiceType | string;
}
export declare namespace ServiceTypeDetail {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: ServiceTypeDetail) => any;
}
/**
 * <p>Describes a service configuration for a VPC endpoint service.</p>
 */
export interface ServiceConfiguration {
    /**
     * <p>The type of service.</p>
     */
    ServiceType?: ServiceTypeDetail[];
    /**
     * <p>The ID of the service.</p>
     */
    ServiceId?: string;
    /**
     * <p>The name of the service.</p>
     */
    ServiceName?: string;
    /**
     * <p>The service state.</p>
     */
    ServiceState?: ServiceState | string;
    /**
     * <p>The Availability Zones in which the service is available.</p>
     */
    AvailabilityZones?: string[];
    /**
     * <p>Indicates whether requests from other Amazon Web Services accounts to create an endpoint to the service must first be accepted.</p>
     */
    AcceptanceRequired?: boolean;
    /**
     * <p>Indicates whether the service manages its VPC endpoints. Management of the service VPC
     *             endpoints using the VPC endpoint API is restricted.</p>
     */
    ManagesVpcEndpoints?: boolean;
    /**
     * <p>The Amazon Resource Names (ARNs) of the Network Load Balancers for the service.</p>
     */
    NetworkLoadBalancerArns?: string[];
    /**
     * <p>The Amazon Resource Names (ARNs) of the Gateway Load Balancers for the service.</p>
     */
    GatewayLoadBalancerArns?: string[];
    /**
     * <p>The DNS names for the service.</p>
     */
    BaseEndpointDnsNames?: string[];
    /**
     * <p>The private DNS name for the service.</p>
     */
    PrivateDnsName?: string;
    /**
     * <p>Information about the endpoint service private DNS name configuration.</p>
     */
    PrivateDnsNameConfiguration?: PrivateDnsNameConfiguration;
    /**
     * <p>Any tags assigned to the service.</p>
     */
    Tags?: Tag[];
}
export declare namespace ServiceConfiguration {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: ServiceConfiguration) => any;
}
export interface CreateVpcEndpointServiceConfigurationResult {
    /**
     * <p>Information about the service configuration.</p>
     */
    ServiceConfiguration?: ServiceConfiguration;
    /**
     * <p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the
     *             request.</p>
     */
    ClientToken?: string;
}
export declare namespace CreateVpcEndpointServiceConfigurationResult {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: CreateVpcEndpointServiceConfigurationResult) => any;
}
export interface CreateVpcPeeringConnectionRequest {
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
    /**
     * <p>The Amazon Web Services account ID of the owner of the accepter VPC.</p>
     *          <p>Default: Your Amazon Web Services account ID</p>
     */
    PeerOwnerId?: string;
    /**
     * <p>The ID of the VPC with which you are creating the VPC peering connection. You must
     * 			specify this parameter in the request.</p>
     */
    PeerVpcId?: string;
    /**
     * <p>The ID of the requester VPC. You must specify this parameter in the
     * 			request.</p>
     */
    VpcId?: string;
    /**
     * <p>The Region code for the accepter VPC, if the accepter VPC is located in a Region
     *             other than the Region in which you make the request.</p>
     * 		       <p>Default: The Region in which you make the request.</p>
     */
    PeerRegion?: string;
    /**
     * <p>The tags to assign to the peering connection.</p>
     */
    TagSpecifications?: TagSpecification[];
}
export declare namespace CreateVpcPeeringConnectionRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: CreateVpcPeeringConnectionRequest) => any;
}
export interface CreateVpcPeeringConnectionResult {
    /**
     * <p>Information about the VPC peering connection.</p>
     */
    VpcPeeringConnection?: VpcPeeringConnection;
}
export declare namespace CreateVpcPeeringConnectionResult {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: CreateVpcPeeringConnectionResult) => any;
}
export declare type TunnelInsideIpVersion = "ipv4" | "ipv6";
/**
 * <p>The IKE version that is permitted for the VPN tunnel.</p>
 */
export interface IKEVersionsRequestListValue {
    /**
     * <p>The IKE version.</p>
     */
    Value?: string;
}
export declare namespace IKEVersionsRequestListValue {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: IKEVersionsRequestListValue) => any;
}
/**
 * <p>Specifies a Diffie-Hellman group number for the VPN tunnel for phase 1 IKE
 *             negotiations.</p>
 */
export interface Phase1DHGroupNumbersRequestListValue {
    /**
     * <p>The Diffie-Hellmann group number.</p>
     */
    Value?: number;
}
export declare namespace Phase1DHGroupNumbersRequestListValue {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: Phase1DHGroupNumbersRequestListValue) => any;
}
/**
 * <p>Specifies the encryption algorithm for the VPN tunnel for phase 1 IKE
 *             negotiations.</p>
 */
export interface Phase1EncryptionAlgorithmsRequestListValue {
    /**
     * <p>The value for the encryption algorithm.</p>
     */
    Value?: string;
}
export declare namespace Phase1EncryptionAlgorithmsRequestListValue {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: Phase1EncryptionAlgorithmsRequestListValue) => any;
}
/**
 * <p>Specifies the integrity algorithm for the VPN tunnel for phase 1 IKE
 *             negotiations.</p>
 */
export interface Phase1IntegrityAlgorithmsRequestListValue {
    /**
     * <p>The value for the integrity algorithm.</p>
     */
    Value?: string;
}
export declare namespace Phase1IntegrityAlgorithmsRequestListValue {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: Phase1IntegrityAlgorithmsRequestListValue) => any;
}
/**
 * <p>Specifies a Diffie-Hellman group number for the VPN tunnel for phase 2 IKE
 *             negotiations.</p>
 */
export interface Phase2DHGroupNumbersRequestListValue {
    /**
     * <p>The Diffie-Hellmann group number.</p>
     */
    Value?: number;
}
export declare namespace Phase2DHGroupNumbersRequestListValue {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: Phase2DHGroupNumbersRequestListValue) => any;
}
/**
 * <p>Specifies the encryption algorithm for the VPN tunnel for phase 2 IKE
 *             negotiations.</p>
 */
export interface Phase2EncryptionAlgorithmsRequestListValue {
    /**
     * <p>The encryption algorithm.</p>
     */
    Value?: string;
}
export declare namespace Phase2EncryptionAlgorithmsRequestListValue {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: Phase2EncryptionAlgorithmsRequestListValue) => any;
}
/**
 * <p>Specifies the integrity algorithm for the VPN tunnel for phase 2 IKE
 *             negotiations.</p>
 */
export interface Phase2IntegrityAlgorithmsRequestListValue {
    /**
     * <p>The integrity algorithm.</p>
     */
    Value?: string;
}
export declare namespace Phase2IntegrityAlgorithmsRequestListValue {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: Phase2IntegrityAlgorithmsRequestListValue) => any;
}
/**
 * <p>The tunnel options for a single VPN tunnel.</p>
 */
export interface VpnTunnelOptionsSpecification {
    /**
     * <p>The range of inside IPv4 addresses for the tunnel. Any specified CIDR blocks must be
     *             unique across all VPN connections that use the same virtual private gateway. </p>
     *         <p>Constraints: A size /30 CIDR block from the <code>169.254.0.0/16</code> range. The
     *             following CIDR blocks are reserved and cannot be used:</p>
     *         <ul>
     *             <li>
     *                 <p>
     *                   <code>169.254.0.0/30</code>
     *                </p>
     *             </li>
     *             <li>
     *                 <p>
     *                   <code>169.254.1.0/30</code>
     *                </p>
     *             </li>
     *             <li>
     *                 <p>
     *                   <code>169.254.2.0/30</code>
     *                </p>
     *             </li>
     *             <li>
     *                 <p>
     *                   <code>169.254.3.0/30</code>
     *                </p>
     *             </li>
     *             <li>
     *                 <p>
     *                   <code>169.254.4.0/30</code>
     *                </p>
     *             </li>
     *             <li>
     *                 <p>
     *                   <code>169.254.5.0/30</code>
     *                </p>
     *             </li>
     *             <li>
     *                 <p>
     *                   <code>169.254.169.252/30</code>
     *                </p>
     *             </li>
     *          </ul>
     */
    TunnelInsideCidr?: string;
    /**
     * <p>The range of inside IPv6 addresses for the tunnel. Any specified CIDR blocks must be
     *             unique across all VPN connections that use the same transit gateway.</p>
     *         <p>Constraints: A size /126 CIDR block from the local <code>fd00::/8</code> range.</p>
     */
    TunnelInsideIpv6Cidr?: string;
    /**
     * <p>The pre-shared key (PSK) to establish initial authentication between the virtual
     *             private gateway and customer gateway.</p>
     *         <p>Constraints: Allowed characters are alphanumeric characters, periods (.), and
     *             underscores (_). Must be between 8 and 64 characters in length and cannot start with
     *             zero (0).</p>
     */
    PreSharedKey?: string;
    /**
     * <p>The lifetime for phase 1 of the IKE negotiation, in seconds.</p>
     *         <p>Constraints: A value between 900 and 28,800.</p>
     *         <p>Default: <code>28800</code>
     *          </p>
     */
    Phase1LifetimeSeconds?: number;
    /**
     * <p>The lifetime for phase 2 of the IKE negotiation, in seconds.</p>
     *         <p>Constraints: A value between 900 and 3,600. The value must be less than the value for
     *                 <code>Phase1LifetimeSeconds</code>.</p>
     *         <p>Default: <code>3600</code>
     *          </p>
     */
    Phase2LifetimeSeconds?: number;
    /**
     * <p>The margin time, in seconds, before the phase 2 lifetime expires, during which the
     *                 Amazon Web Services side of the VPN connection performs an IKE rekey. The exact time
     *             of the rekey is randomly selected based on the value for
     *                 <code>RekeyFuzzPercentage</code>.</p>
     *         <p>Constraints: A value between 60 and half of <code>Phase2LifetimeSeconds</code>.</p>
     *         <p>Default: <code>540</code>
     *          </p>
     */
    RekeyMarginTimeSeconds?: number;
    /**
     * <p>The percentage of the rekey window (determined by <code>RekeyMarginTimeSeconds</code>)
     *             during which the rekey time is randomly selected.</p>
     *         <p>Constraints: A value between 0 and 100.</p>
     *         <p>Default: <code>100</code>
     *          </p>
     */
    RekeyFuzzPercentage?: number;
    /**
     * <p>The number of packets in an IKE replay window.</p>
     *         <p>Constraints: A value between 64 and 2048.</p>
     *         <p>Default: <code>1024</code>
     *          </p>
     */
    ReplayWindowSize?: number;
    /**
     * <p>The number of seconds after which a DPD timeout occurs.</p>
     *         <p>Constraints: A value between 0 and 30.</p>
     *         <p>Default: <code>30</code>
     *          </p>
     */
    DPDTimeoutSeconds?: number;
    /**
     * <p>The action to take after DPD timeout occurs. Specify <code>restart</code> to restart
     *             the IKE initiation. Specify <code>clear</code> to end the IKE session.</p>
     *         <p>Valid Values: <code>clear</code> | <code>none</code> | <code>restart</code>
     *          </p>
     *         <p>Default: <code>clear</code>
     *          </p>
     */
    DPDTimeoutAction?: string;
    /**
     * <p>One or more encryption algorithms that are permitted for the VPN tunnel for phase 1
     *             IKE negotiations.</p>
     *         <p>Valid values: <code>AES128</code> | <code>AES256</code> | <code>AES128-GCM-16</code> |
     *                 <code>AES256-GCM-16</code>
     *          </p>
     */
    Phase1EncryptionAlgorithms?: Phase1EncryptionAlgorithmsRequestListValue[];
    /**
     * <p>One or more encryption algorithms that are permitted for the VPN tunnel for phase 2
     *             IKE negotiations.</p>
     *         <p>Valid values: <code>AES128</code> | <code>AES256</code> | <code>AES128-GCM-16</code> |
     *                 <code>AES256-GCM-16</code>
     *          </p>
     */
    Phase2EncryptionAlgorithms?: Phase2EncryptionAlgorithmsRequestListValue[];
    /**
     * <p>One or more integrity algorithms that are permitted for the VPN tunnel for phase 1 IKE
     *             negotiations.</p>
     *         <p>Valid values: <code>SHA1</code> | <code>SHA2-256</code> | <code>SHA2-384</code> |
     *                 <code>SHA2-512</code>
     *          </p>
     */
    Phase1IntegrityAlgorithms?: Phase1IntegrityAlgorithmsRequestListValue[];
    /**
     * <p>One or more integrity algorithms that are permitted for the VPN tunnel for phase 2 IKE
     *             negotiations.</p>
     *         <p>Valid values: <code>SHA1</code> | <code>SHA2-256</code> | <code>SHA2-384</code> |
     *                 <code>SHA2-512</code>
     *          </p>
     */
    Phase2IntegrityAlgorithms?: Phase2IntegrityAlgorithmsRequestListValue[];
    /**
     * <p>One or more Diffie-Hellman group numbers that are permitted for the VPN tunnel for
     *             phase 1 IKE negotiations.</p>
     *         <p>Valid values: <code>2</code> | <code>14</code> | <code>15</code> | <code>16</code> |
     *                 <code>17</code> | <code>18</code> | <code>19</code> | <code>20</code> |
     *                 <code>21</code> | <code>22</code> | <code>23</code> | <code>24</code>
     *          </p>
     */
    Phase1DHGroupNumbers?: Phase1DHGroupNumbersRequestListValue[];
    /**
     * <p>One or more Diffie-Hellman group numbers that are permitted for the VPN tunnel for
     *             phase 2 IKE negotiations.</p>
     *         <p>Valid values: <code>2</code> | <code>5</code> | <code>14</code> | <code>15</code> |
     *                 <code>16</code> | <code>17</code> | <code>18</code> | <code>19</code> |
     *                 <code>20</code> | <code>21</code> | <code>22</code> | <code>23</code> |
     *                 <code>24</code>
     *          </p>
     */
    Phase2DHGroupNumbers?: Phase2DHGroupNumbersRequestListValue[];
    /**
     * <p>The IKE versions that are permitted for the VPN tunnel.</p>
     *         <p>Valid values: <code>ikev1</code> | <code>ikev2</code>
     *          </p>
     */
    IKEVersions?: IKEVersionsRequestListValue[];
    /**
     * <p>The action to take when the establishing the tunnel for the VPN connection. By
     *             default, your customer gateway device must initiate the IKE negotiation and bring up the
     *             tunnel. Specify <code>start</code> for Amazon Web Services to initiate the IKE
     *             negotiation.</p>
     *         <p>Valid Values: <code>add</code> | <code>start</code>
     *          </p>
     *         <p>Default: <code>add</code>
     *          </p>
     */
    StartupAction?: string;
}
export declare namespace VpnTunnelOptionsSpecification {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: VpnTunnelOptionsSpecification) => any;
}
/**
 * <p>Describes VPN connection options.</p>
 */
export interface VpnConnectionOptionsSpecification {
    /**
     * <p>Indicate whether to enable acceleration for the VPN connection.</p>
     *         <p>Default: <code>false</code>
     *          </p>
     */
    EnableAcceleration?: boolean;
    /**
     * <p>Indicate whether the VPN connection uses static routes only. If you are creating a VPN
     *             connection for a device that does not support BGP, you must specify <code>true</code>.
     *             Use <a>CreateVpnConnectionRoute</a> to create a static route.</p>
     *         <p>Default: <code>false</code>
     *          </p>
     */
    StaticRoutesOnly?: boolean;
    /**
     * <p>Indicate whether the VPN tunnels process IPv4 or IPv6 traffic.</p>
     *         <p>Default: <code>ipv4</code>
     *          </p>
     */
    TunnelInsideIpVersion?: TunnelInsideIpVersion | string;
    /**
     * <p>The tunnel options for the VPN connection.</p>
     */
    TunnelOptions?: VpnTunnelOptionsSpecification[];
    /**
     * <p>The IPv4 CIDR on the customer gateway (on-premises) side of the VPN connection.</p>
     *         <p>Default: <code>0.0.0.0/0</code>
     *          </p>
     */
    LocalIpv4NetworkCidr?: string;
    /**
     * <p>The IPv4 CIDR on the Amazon Web Services side of the VPN connection.</p>
     *         <p>Default: <code>0.0.0.0/0</code>
     *          </p>
     */
    RemoteIpv4NetworkCidr?: string;
    /**
     * <p>The IPv6 CIDR on the customer gateway (on-premises) side of the VPN connection.</p>
     *         <p>Default: <code>::/0</code>
     *          </p>
     */
    LocalIpv6NetworkCidr?: string;
    /**
     * <p>The IPv6 CIDR on the Amazon Web Services side of the VPN connection.</p>
     *         <p>Default: <code>::/0</code>
     *          </p>
     */
    RemoteIpv6NetworkCidr?: string;
}
export declare namespace VpnConnectionOptionsSpecification {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: VpnConnectionOptionsSpecification) => any;
}
/**
 * <p>Contains the parameters for CreateVpnConnection.</p>
 */
export interface CreateVpnConnectionRequest {
    /**
     * <p>The ID of the customer gateway.</p>
     */
    CustomerGatewayId: string | undefined;
    /**
     * <p>The type of VPN connection (<code>ipsec.1</code>).</p>
     */
    Type: string | undefined;
    /**
     * <p>The ID of the virtual private gateway. If you specify a virtual private gateway, you
     *             cannot specify a transit gateway.</p>
     */
    VpnGatewayId?: string;
    /**
     * <p>The ID of the transit gateway. If you specify a transit gateway, you cannot specify a virtual private
     *             gateway.</p>
     */
    TransitGatewayId?: string;
    /**
     * <p>Checks whether you have the required permissions for the action, without actually
     *             making the request, and provides an error response. If you have the required
     *             permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is
     *                 <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
    /**
     * <p>The options for the VPN connection.</p>
     */
    Options?: VpnConnectionOptionsSpecification;
    /**
     * <p>The tags to apply to the VPN connection.</p>
     */
    TagSpecifications?: TagSpecification[];
}
export declare namespace CreateVpnConnectionRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: CreateVpnConnectionRequest) => any;
}
export declare enum GatewayAssociationState {
    associated = "associated",
    associating = "associating",
    disassociating = "disassociating",
    not_associated = "not-associated"
}
/**
 * <p>The internet key exchange (IKE) version permitted for the VPN tunnel.</p>
 */
export interface IKEVersionsListValue {
    /**
     * <p>The IKE version.</p>
     */
    Value?: string;
}
export declare namespace IKEVersionsListValue {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: IKEVersionsListValue) => any;
}
/**
 * <p>The Diffie-Hellmann group number for phase 1 IKE negotiations.</p>
 */
export interface Phase1DHGroupNumbersListValue {
    /**
     * <p>The Diffie-Hellmann group number.</p>
     */
    Value?: number;
}
export declare namespace Phase1DHGroupNumbersListValue {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: Phase1DHGroupNumbersListValue) => any;
}
/**
 * <p>The encryption algorithm for phase 1 IKE negotiations.</p>
 */
export interface Phase1EncryptionAlgorithmsListValue {
    /**
     * <p>The value for the encryption algorithm.</p>
     */
    Value?: string;
}
export declare namespace Phase1EncryptionAlgorithmsListValue {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: Phase1EncryptionAlgorithmsListValue) => any;
}
/**
 * <p>The integrity algorithm for phase 1 IKE negotiations.</p>
 */
export interface Phase1IntegrityAlgorithmsListValue {
    /**
     * <p>The value for the integrity algorithm.</p>
     */
    Value?: string;
}
export declare namespace Phase1IntegrityAlgorithmsListValue {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: Phase1IntegrityAlgorithmsListValue) => any;
}
/**
 * <p>The Diffie-Hellmann group number for phase 2 IKE negotiations.</p>
 */
export interface Phase2DHGroupNumbersListValue {
    /**
     * <p>The Diffie-Hellmann group number.</p>
     */
    Value?: number;
}
export declare namespace Phase2DHGroupNumbersListValue {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: Phase2DHGroupNumbersListValue) => any;
}
/**
 * <p>The encryption algorithm for phase 2 IKE negotiations.</p>
 */
export interface Phase2EncryptionAlgorithmsListValue {
    /**
     * <p>The encryption algorithm.</p>
     */
    Value?: string;
}
export declare namespace Phase2EncryptionAlgorithmsListValue {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: Phase2EncryptionAlgorithmsListValue) => any;
}
/**
 * <p>The integrity algorithm for phase 2 IKE negotiations.</p>
 */
export interface Phase2IntegrityAlgorithmsListValue {
    /**
     * <p>The integrity algorithm.</p>
     */
    Value?: string;
}
export declare namespace Phase2IntegrityAlgorithmsListValue {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: Phase2IntegrityAlgorithmsListValue) => any;
}
/**
 * <p>The VPN tunnel options.</p>
 */
export interface TunnelOption {
    /**
     * <p>The external IP address of the VPN tunnel.</p>
     */
    OutsideIpAddress?: string;
    /**
     * <p>The range of inside IPv4 addresses for the tunnel.</p>
     */
    TunnelInsideCidr?: string;
    /**
     * <p>The range of inside IPv6 addresses for the tunnel.</p>
     */
    TunnelInsideIpv6Cidr?: string;
    /**
     * <p>The pre-shared key (PSK) to establish initial authentication between the virtual
     *             private gateway and the customer gateway.</p>
     */
    PreSharedKey?: string;
    /**
     * <p>The lifetime for phase 1 of the IKE negotiation, in seconds.</p>
     */
    Phase1LifetimeSeconds?: number;
    /**
     * <p>The lifetime for phase 2 of the IKE negotiation, in seconds.</p>
     */
    Phase2LifetimeSeconds?: number;
    /**
     * <p>The margin time, in seconds, before the phase 2 lifetime expires, during which the
     *                 Amazon Web Services side of the VPN connection performs an IKE rekey.</p>
     */
    RekeyMarginTimeSeconds?: number;
    /**
     * <p>The percentage of the rekey window determined by <code>RekeyMarginTimeSeconds</code>
     *             during which the rekey time is randomly selected.</p>
     */
    RekeyFuzzPercentage?: number;
    /**
     * <p>The number of packets in an IKE replay window.</p>
     */
    ReplayWindowSize?: number;
    /**
     * <p>The number of seconds after which a DPD timeout occurs.</p>
     */
    DpdTimeoutSeconds?: number;
    /**
     * <p>The action to take after a DPD timeout occurs.</p>
     */
    DpdTimeoutAction?: string;
    /**
     * <p>The permitted encryption algorithms for the VPN tunnel for phase 1 IKE
     *             negotiations.</p>
     */
    Phase1EncryptionAlgorithms?: Phase1EncryptionAlgorithmsListValue[];
    /**
     * <p>The permitted encryption algorithms for the VPN tunnel for phase 2 IKE
     *             negotiations.</p>
     */
    Phase2EncryptionAlgorithms?: Phase2EncryptionAlgorithmsListValue[];
    /**
     * <p>The permitted integrity algorithms for the VPN tunnel for phase 1 IKE
     *             negotiations.</p>
     */
    Phase1IntegrityAlgorithms?: Phase1IntegrityAlgorithmsListValue[];
    /**
     * <p>The permitted integrity algorithms for the VPN tunnel for phase 2 IKE
     *             negotiations.</p>
     */
    Phase2IntegrityAlgorithms?: Phase2IntegrityAlgorithmsListValue[];
    /**
     * <p>The permitted Diffie-Hellman group numbers for the VPN tunnel for phase 1 IKE
     *             negotiations.</p>
     */
    Phase1DHGroupNumbers?: Phase1DHGroupNumbersListValue[];
    /**
     * <p>The permitted Diffie-Hellman group numbers for the VPN tunnel for phase 2 IKE
     *             negotiations.</p>
     */
    Phase2DHGroupNumbers?: Phase2DHGroupNumbersListValue[];
    /**
     * <p>The IKE versions that are permitted for the VPN tunnel.</p>
     */
    IkeVersions?: IKEVersionsListValue[];
    /**
     * <p>The action to take when the establishing the VPN tunnels for a VPN connection.</p>
     */
    StartupAction?: string;
}
export declare namespace TunnelOption {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: TunnelOption) => any;
}
/**
 * <p>Describes VPN connection options.</p>
 */
export interface VpnConnectionOptions {
    /**
     * <p>Indicates whether acceleration is enabled for the VPN connection.</p>
     */
    EnableAcceleration?: boolean;
    /**
     * <p>Indicates whether the VPN connection uses static routes only. Static routes must be
     *             used for devices that don't support BGP.</p>
     */
    StaticRoutesOnly?: boolean;
    /**
     * <p>The IPv4 CIDR on the customer gateway (on-premises) side of the VPN connection.</p>
     */
    LocalIpv4NetworkCidr?: string;
    /**
     * <p>The IPv4 CIDR on the Amazon Web Services side of the VPN connection.</p>
     */
    RemoteIpv4NetworkCidr?: string;
    /**
     * <p>The IPv6 CIDR on the customer gateway (on-premises) side of the VPN connection.</p>
     */
    LocalIpv6NetworkCidr?: string;
    /**
     * <p>The IPv6 CIDR on the Amazon Web Services side of the VPN connection.</p>
     */
    RemoteIpv6NetworkCidr?: string;
    /**
     * <p>Indicates whether the VPN tunnels process IPv4 or IPv6 traffic.</p>
     */
    TunnelInsideIpVersion?: TunnelInsideIpVersion | string;
    /**
     * <p>Indicates the VPN tunnel options.</p>
     */
    TunnelOptions?: TunnelOption[];
}
export declare namespace VpnConnectionOptions {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: VpnConnectionOptions) => any;
}
export declare type VpnStaticRouteSource = "Static";
export declare type VpnState = "available" | "deleted" | "deleting" | "pending";
/**
 * <p>Describes a static route for a VPN connection.</p>
 */
export interface VpnStaticRoute {
    /**
     * <p>The CIDR block associated with the local subnet of the customer data center.</p>
     */
    DestinationCidrBlock?: string;
    /**
     * <p>Indicates how the routes were provided.</p>
     */
    Source?: VpnStaticRouteSource | string;
    /**
     * <p>The current state of the static route.</p>
     */
    State?: VpnState | string;
}
export declare namespace VpnStaticRoute {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: VpnStaticRoute) => any;
}
export declare type TelemetryStatus = "DOWN" | "UP";
/**
 * <p>Describes telemetry for a VPN tunnel.</p>
 */
export interface VgwTelemetry {
    /**
     * <p>The number of accepted routes.</p>
     */
    AcceptedRouteCount?: number;
    /**
     * <p>The date and time of the last change in status.</p>
     */
    LastStatusChange?: Date;
    /**
     * <p>The Internet-routable IP address of the virtual private gateway's outside
     *             interface.</p>
     */
    OutsideIpAddress?: string;
    /**
     * <p>The status of the VPN tunnel.</p>
     */
    Status?: TelemetryStatus | string;
    /**
     * <p>If an error occurs, a description of the error.</p>
     */
    StatusMessage?: string;
    /**
     * <p>The Amazon Resource Name (ARN) of the VPN tunnel endpoint certificate.</p>
     */
    CertificateArn?: string;
}
export declare namespace VgwTelemetry {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: VgwTelemetry) => any;
}
/**
 * <p>Describes a VPN connection.</p>
 */
export interface VpnConnection {
    /**
     * <p>The configuration information for the VPN connection's customer gateway (in the native
     *             XML format). This element is always present in the <a>CreateVpnConnection</a>
     *             response; however, it's present in the <a>DescribeVpnConnections</a> response
     *             only if the VPN connection is in the <code>pending</code> or <code>available</code>
     *             state.</p>
     */
    CustomerGatewayConfiguration?: string;
    /**
     * <p>The ID of the customer gateway at your end of the VPN connection.</p>
     */
    CustomerGatewayId?: string;
    /**
     * <p>The category of the VPN connection. A value of <code>VPN</code> indicates an Amazon Web Services VPN connection. A value of <code>VPN-Classic</code> indicates an Amazon Web Services Classic VPN connection.</p>
     */
    Category?: string;
    /**
     * <p>The current state of the VPN connection.</p>
     */
    State?: VpnState | string;
    /**
     * <p>The type of VPN connection.</p>
     */
    Type?: GatewayType | string;
    /**
     * <p>The ID of the VPN connection.</p>
     */
    VpnConnectionId?: string;
    /**
     * <p>The ID of the virtual private gateway at the Amazon Web Services side of the VPN
     *             connection.</p>
     */
    VpnGatewayId?: string;
    /**
     * <p>The ID of the transit gateway associated with the VPN connection.</p>
     */
    TransitGatewayId?: string;
    /**
     * <p>The ARN of the core network.</p>
     */
    CoreNetworkArn?: string;
    /**
     * <p>The ARN of the core network attachment.</p>
     */
    CoreNetworkAttachmentArn?: string;
    /**
     * <p>The current state of the gateway association.</p>
     */
    GatewayAssociationState?: GatewayAssociationState | string;
    /**
     * <p>The VPN connection options.</p>
     */
    Options?: VpnConnectionOptions;
    /**
     * <p>The static routes associated with the VPN connection.</p>
     */
    Routes?: VpnStaticRoute[];
    /**
     * <p>Any tags assigned to the VPN connection.</p>
     */
    Tags?: Tag[];
    /**
     * <p>Information about the VPN tunnel.</p>
     */
    VgwTelemetry?: VgwTelemetry[];
}
export declare namespace VpnConnection {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: VpnConnection) => any;
}
/**
 * <p>Contains the output of CreateVpnConnection.</p>
 */
export interface CreateVpnConnectionResult {
    /**
     * <p>Information about the VPN connection.</p>
     */
    VpnConnection?: VpnConnection;
}
export declare namespace CreateVpnConnectionResult {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: CreateVpnConnectionResult) => any;
}
/**
 * <p>Contains the parameters for CreateVpnConnectionRoute.</p>
 */
export interface CreateVpnConnectionRouteRequest {
    /**
     * <p>The CIDR block associated with the local subnet of the customer network.</p>
     */
    DestinationCidrBlock: string | undefined;
    /**
     * <p>The ID of the VPN connection.</p>
     */
    VpnConnectionId: string | undefined;
}
export declare namespace CreateVpnConnectionRouteRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: CreateVpnConnectionRouteRequest) => any;
}
/**
 * <p>Contains the parameters for CreateVpnGateway.</p>
 */
export interface CreateVpnGatewayRequest {
    /**
     * <p>The Availability Zone for the virtual private gateway.</p>
     */
    AvailabilityZone?: string;
    /**
     * <p>The type of VPN connection this virtual private gateway supports.</p>
     */
    Type: GatewayType | string | undefined;
    /**
     * <p>The tags to apply to the virtual private gateway.</p>
     */
    TagSpecifications?: TagSpecification[];
    /**
     * <p>A private Autonomous System Number (ASN) for the Amazon side of a BGP session. If
     *             you're using a 16-bit ASN, it must be in the 64512 to 65534 range. If you're using a
     *             32-bit ASN, it must be in the 4200000000 to 4294967294 range.</p>
     *         <p>Default: 64512</p>
     */
    AmazonSideAsn?: number;
    /**
     * <p>Checks whether you have the required permissions for the action, without actually
     *             making the request, and provides an error response. If you have the required
     *             permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is
     *                 <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
}
export declare namespace CreateVpnGatewayRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: CreateVpnGatewayRequest) => any;
}
/**
 * <p>Describes a virtual private gateway.</p>
 */
export interface VpnGateway {
    /**
     * <p>The Availability Zone where the virtual private gateway was created, if applicable.
     *             This field may be empty or not returned.</p>
     */
    AvailabilityZone?: string;
    /**
     * <p>The current state of the virtual private gateway.</p>
     */
    State?: VpnState | string;
    /**
     * <p>The type of VPN connection the virtual private gateway supports.</p>
     */
    Type?: GatewayType | string;
    /**
     * <p>Any VPCs attached to the virtual private gateway.</p>
     */
    VpcAttachments?: VpcAttachment[];
    /**
     * <p>The ID of the virtual private gateway.</p>
     */
    VpnGatewayId?: string;
    /**
     * <p>The private Autonomous System Number (ASN) for the Amazon side of a BGP
     *             session.</p>
     */
    AmazonSideAsn?: number;
    /**
     * <p>Any tags assigned to the virtual private gateway.</p>
     */
    Tags?: Tag[];
}
export declare namespace VpnGateway {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: VpnGateway) => any;
}
/**
 * <p>Contains the output of CreateVpnGateway.</p>
 */
export interface CreateVpnGatewayResult {
    /**
     * <p>Information about the virtual private gateway.</p>
     */
    VpnGateway?: VpnGateway;
}
export declare namespace CreateVpnGatewayResult {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: CreateVpnGatewayResult) => any;
}
export interface DeleteCarrierGatewayRequest {
    /**
     * <p>The ID of the carrier gateway.</p>
     */
    CarrierGatewayId: string | undefined;
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
}
export declare namespace DeleteCarrierGatewayRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DeleteCarrierGatewayRequest) => any;
}
export interface DeleteCarrierGatewayResult {
    /**
     * <p>Information about the carrier gateway.</p>
     */
    CarrierGateway?: CarrierGateway;
}
export declare namespace DeleteCarrierGatewayResult {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DeleteCarrierGatewayResult) => any;
}
export interface DeleteClientVpnEndpointRequest {
    /**
     * <p>The ID of the Client VPN to be deleted.</p>
     */
    ClientVpnEndpointId: string | undefined;
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
}
export declare namespace DeleteClientVpnEndpointRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DeleteClientVpnEndpointRequest) => any;
}
export interface DeleteClientVpnEndpointResult {
    /**
     * <p>The current state of the Client VPN endpoint.</p>
     */
    Status?: ClientVpnEndpointStatus;
}
export declare namespace DeleteClientVpnEndpointResult {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DeleteClientVpnEndpointResult) => any;
}
export interface DeleteClientVpnRouteRequest {
    /**
     * <p>The ID of the Client VPN endpoint from which the route is to be deleted.</p>
     */
    ClientVpnEndpointId: string | undefined;
    /**
     * <p>The ID of the target subnet used by the route.</p>
     */
    TargetVpcSubnetId?: string;
    /**
     * <p>The IPv4 address range, in CIDR notation, of the route to be deleted.</p>
     */
    DestinationCidrBlock: string | undefined;
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
}
export declare namespace DeleteClientVpnRouteRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DeleteClientVpnRouteRequest) => any;
}
export interface DeleteClientVpnRouteResult {
    /**
     * <p>The current state of the route.</p>
     */
    Status?: ClientVpnRouteStatus;
}
export declare namespace DeleteClientVpnRouteResult {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DeleteClientVpnRouteResult) => any;
}
/**
 * <p>Contains the parameters for DeleteCustomerGateway.</p>
 */
export interface DeleteCustomerGatewayRequest {
    /**
     * <p>The ID of the customer gateway.</p>
     */
    CustomerGatewayId: string | undefined;
    /**
     * <p>Checks whether you have the required permissions for the action, without actually
     *             making the request, and provides an error response. If you have the required
     *             permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is
     *                 <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
}
export declare namespace DeleteCustomerGatewayRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DeleteCustomerGatewayRequest) => any;
}
export interface DeleteDhcpOptionsRequest {
    /**
     * <p>The ID of the DHCP options set.</p>
     */
    DhcpOptionsId: string | undefined;
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
}
export declare namespace DeleteDhcpOptionsRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DeleteDhcpOptionsRequest) => any;
}
export interface DeleteEgressOnlyInternetGatewayRequest {
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
    /**
     * <p>The ID of the egress-only internet gateway.</p>
     */
    EgressOnlyInternetGatewayId: string | undefined;
}
export declare namespace DeleteEgressOnlyInternetGatewayRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DeleteEgressOnlyInternetGatewayRequest) => any;
}
export interface DeleteEgressOnlyInternetGatewayResult {
    /**
     * <p>Returns <code>true</code> if the request succeeds; otherwise, it returns an error.</p>
     */
    ReturnCode?: boolean;
}
export declare namespace DeleteEgressOnlyInternetGatewayResult {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DeleteEgressOnlyInternetGatewayResult) => any;
}
export interface DeleteFleetsRequest {
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
    /**
     * <p>The IDs of the EC2 Fleets.</p>
     */
    FleetIds: string[] | undefined;
    /**
     * <p>Indicates whether to terminate the instances when the EC2 Fleet is deleted. The default is to
     *          terminate the instances.</p>
     *          <p>To let the instances continue to run after the EC2 Fleet is deleted, specify
     *             <code>NoTerminateInstances</code>. Supported only for fleets of type
     *             <code>maintain</code> and <code>request</code>.</p>
     *          <p>For <code>instant</code> fleets, you cannot specify <code>NoTerminateInstances</code>. A
     *          deleted <code>instant</code> fleet with running instances is not supported.</p>
     */
    TerminateInstances: boolean | undefined;
}
export declare namespace DeleteFleetsRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DeleteFleetsRequest) => any;
}
export declare enum FleetStateCode {
    ACTIVE = "active",
    DELETED = "deleted",
    DELETED_RUNNING = "deleted_running",
    DELETED_TERMINATING_INSTANCES = "deleted_terminating",
    FAILED = "failed",
    MODIFYING = "modifying",
    SUBMITTED = "submitted"
}
/**
 * <p>Describes an EC2 Fleet that was successfully deleted.</p>
 */
export interface DeleteFleetSuccessItem {
    /**
     * <p>The current state of the EC2 Fleet.</p>
     */
    CurrentFleetState?: FleetStateCode | string;
    /**
     * <p>The previous state of the EC2 Fleet.</p>
     */
    PreviousFleetState?: FleetStateCode | string;
    /**
     * <p>The ID of the EC2 Fleet.</p>
     */
    FleetId?: string;
}
export declare namespace DeleteFleetSuccessItem {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DeleteFleetSuccessItem) => any;
}
export declare enum DeleteFleetErrorCode {
    FLEET_ID_DOES_NOT_EXIST = "fleetIdDoesNotExist",
    FLEET_ID_MALFORMED = "fleetIdMalformed",
    FLEET_NOT_IN_DELETABLE_STATE = "fleetNotInDeletableState",
    UNEXPECTED_ERROR = "unexpectedError"
}
/**
 * <p>Describes an EC2 Fleet error.</p>
 */
export interface DeleteFleetError {
    /**
     * <p>The error code.</p>
     */
    Code?: DeleteFleetErrorCode | string;
    /**
     * <p>The description for the error code.</p>
     */
    Message?: string;
}
export declare namespace DeleteFleetError {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DeleteFleetError) => any;
}
/**
 * <p>Describes an EC2 Fleet that was not successfully deleted.</p>
 */
export interface DeleteFleetErrorItem {
    /**
     * <p>The error.</p>
     */
    Error?: DeleteFleetError;
    /**
     * <p>The ID of the EC2 Fleet.</p>
     */
    FleetId?: string;
}
export declare namespace DeleteFleetErrorItem {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DeleteFleetErrorItem) => any;
}
export interface DeleteFleetsResult {
    /**
     * <p>Information about the EC2 Fleets that are successfully deleted.</p>
     */
    SuccessfulFleetDeletions?: DeleteFleetSuccessItem[];
    /**
     * <p>Information about the EC2 Fleets that are not successfully deleted.</p>
     */
    UnsuccessfulFleetDeletions?: DeleteFleetErrorItem[];
}
export declare namespace DeleteFleetsResult {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DeleteFleetsResult) => any;
}
export interface DeleteFlowLogsRequest {
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
    /**
     * <p>One or more flow log IDs.</p>
     *         <p>Constraint: Maximum of 1000 flow log IDs.</p>
     */
    FlowLogIds: string[] | undefined;
}
export declare namespace DeleteFlowLogsRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DeleteFlowLogsRequest) => any;
}
export interface DeleteFlowLogsResult {
    /**
     * <p>Information about the flow logs that could not be deleted successfully.</p>
     */
    Unsuccessful?: UnsuccessfulItem[];
}
export declare namespace DeleteFlowLogsResult {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DeleteFlowLogsResult) => any;
}
export interface DeleteFpgaImageRequest {
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
    /**
     * <p>The ID of the AFI.</p>
     */
    FpgaImageId: string | undefined;
}
export declare namespace DeleteFpgaImageRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DeleteFpgaImageRequest) => any;
}
export interface DeleteFpgaImageResult {
    /**
     * <p>Is <code>true</code> if the request succeeds, and an error otherwise.</p>
     */
    Return?: boolean;
}
export declare namespace DeleteFpgaImageResult {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DeleteFpgaImageResult) => any;
}
export interface DeleteInstanceEventWindowRequest {
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
    /**
     * <p>Specify <code>true</code> to force delete the event window. Use the force delete parameter
     *          if the event window is currently associated with targets.</p>
     */
    ForceDelete?: boolean;
    /**
     * <p>The ID of the event window.</p>
     */
    InstanceEventWindowId: string | undefined;
}
export declare namespace DeleteInstanceEventWindowRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DeleteInstanceEventWindowRequest) => any;
}
/**
 * <p>The state of the event window.</p>
 */
export interface InstanceEventWindowStateChange {
    /**
     * <p>The ID of the event window.</p>
     */
    InstanceEventWindowId?: string;
    /**
     * <p>The current state of the event window.</p>
     */
    State?: InstanceEventWindowState | string;
}
export declare namespace InstanceEventWindowStateChange {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: InstanceEventWindowStateChange) => any;
}
export interface DeleteInstanceEventWindowResult {
    /**
     * <p>The state of the event window.</p>
     */
    InstanceEventWindowState?: InstanceEventWindowStateChange;
}
export declare namespace DeleteInstanceEventWindowResult {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DeleteInstanceEventWindowResult) => any;
}
export interface DeleteInternetGatewayRequest {
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
    /**
     * <p>The ID of the internet gateway.</p>
     */
    InternetGatewayId: string | undefined;
}
export declare namespace DeleteInternetGatewayRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DeleteInternetGatewayRequest) => any;
}
export interface DeleteIpamRequest {
    /**
     * <p>A check for whether you have the required permissions for the action without actually making the request
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
    /**
     * <p>The ID of the IPAM to delete.</p>
     */
    IpamId: string | undefined;
}
export declare namespace DeleteIpamRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DeleteIpamRequest) => any;
}
export interface DeleteIpamResult {
    /**
     * <p>Information about the results of the deletion.</p>
     */
    Ipam?: Ipam;
}
export declare namespace DeleteIpamResult {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DeleteIpamResult) => any;
}
export interface DeleteIpamPoolRequest {
    /**
     * <p>A check for whether you have the required permissions for the action without actually making the request
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
    /**
     * <p>The ID of the pool to delete.</p>
     */
    IpamPoolId: string | undefined;
}
export declare namespace DeleteIpamPoolRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DeleteIpamPoolRequest) => any;
}
export interface DeleteIpamPoolResult {
    /**
     * <p>Information about the results of the deletion.</p>
     */
    IpamPool?: IpamPool;
}
export declare namespace DeleteIpamPoolResult {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DeleteIpamPoolResult) => any;
}
export interface DeleteIpamScopeRequest {
    /**
     * <p>A check for whether you have the required permissions for the action without actually making the request
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
    /**
     * <p>The ID of the scope to delete.</p>
     */
    IpamScopeId: string | undefined;
}
export declare namespace DeleteIpamScopeRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DeleteIpamScopeRequest) => any;
}
export interface DeleteIpamScopeResult {
    /**
     * <p>Information about the results of the deletion.</p>
     */
    IpamScope?: IpamScope;
}
export declare namespace DeleteIpamScopeResult {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DeleteIpamScopeResult) => any;
}
export interface DeleteKeyPairRequest {
    /**
     * <p>The name of the key pair.</p>
     */
    KeyName?: string;
    /**
     * <p>The ID of the key pair.</p>
     */
    KeyPairId?: string;
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
}
export declare namespace DeleteKeyPairRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DeleteKeyPairRequest) => any;
}
export interface DeleteLaunchTemplateRequest {
    /**
     * <p>Checks whether you have the required permissions for the action, without actually
     *             making the request, and provides an error response. If you have the required
     *             permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is
     *                 <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
    /**
     * <p>The ID of the launch template. You must specify either the launch template ID or
     *             launch template name in the request.</p>
     */
    LaunchTemplateId?: string;
    /**
     * <p>The name of the launch template. You must specify either the launch template ID or
     *             launch template name in the request.</p>
     */
    LaunchTemplateName?: string;
}
export declare namespace DeleteLaunchTemplateRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DeleteLaunchTemplateRequest) => any;
}
export interface DeleteLaunchTemplateResult {
    /**
     * <p>Information about the launch template.</p>
     */
    LaunchTemplate?: LaunchTemplate;
}
export declare namespace DeleteLaunchTemplateResult {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DeleteLaunchTemplateResult) => any;
}
export interface DeleteLaunchTemplateVersionsRequest {
    /**
     * <p>Checks whether you have the required permissions for the action, without actually
     *             making the request, and provides an error response. If you have the required
     *             permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is
     *                 <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
    /**
     * <p>The ID of the launch template. You must specify either the launch template ID or
     *             launch template name in the request.</p>
     */
    LaunchTemplateId?: string;
    /**
     * <p>The name of the launch template. You must specify either the launch template ID or
     *             launch template name in the request.</p>
     */
    LaunchTemplateName?: string;
    /**
     * <p>The version numbers of one or more launch template versions to delete.</p>
     */
    Versions: string[] | undefined;
}
export declare namespace DeleteLaunchTemplateVersionsRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DeleteLaunchTemplateVersionsRequest) => any;
}
/**
 * <p>Describes a launch template version that was successfully deleted.</p>
 */
export interface DeleteLaunchTemplateVersionsResponseSuccessItem {
    /**
     * <p>The ID of the launch template.</p>
     */
    LaunchTemplateId?: string;
    /**
     * <p>The name of the launch template.</p>
     */
    LaunchTemplateName?: string;
    /**
     * <p>The version number of the launch template.</p>
     */
    VersionNumber?: number;
}
export declare namespace DeleteLaunchTemplateVersionsResponseSuccessItem {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DeleteLaunchTemplateVersionsResponseSuccessItem) => any;
}
export declare enum LaunchTemplateErrorCode {
    LAUNCH_TEMPLATE_ID_DOES_NOT_EXIST = "launchTemplateIdDoesNotExist",
    LAUNCH_TEMPLATE_ID_MALFORMED = "launchTemplateIdMalformed",
    LAUNCH_TEMPLATE_NAME_DOES_NOT_EXIST = "launchTemplateNameDoesNotExist",
    LAUNCH_TEMPLATE_NAME_MALFORMED = "launchTemplateNameMalformed",
    LAUNCH_TEMPLATE_VERSION_DOES_NOT_EXIST = "launchTemplateVersionDoesNotExist",
    UNEXPECTED_ERROR = "unexpectedError"
}
/**
 * <p>Describes the error that's returned when you cannot delete a launch template
 *             version.</p>
 */
export interface ResponseError {
    /**
     * <p>The error code.</p>
     */
    Code?: LaunchTemplateErrorCode | string;
    /**
     * <p>The error message, if applicable.</p>
     */
    Message?: string;
}
export declare namespace ResponseError {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: ResponseError) => any;
}
/**
 * <p>Describes a launch template version that could not be deleted.</p>
 */
export interface DeleteLaunchTemplateVersionsResponseErrorItem {
    /**
     * <p>The ID of the launch template.</p>
     */
    LaunchTemplateId?: string;
    /**
     * <p>The name of the launch template.</p>
     */
    LaunchTemplateName?: string;
    /**
     * <p>The version number of the launch template.</p>
     */
    VersionNumber?: number;
    /**
     * <p>Information about the error.</p>
     */
    ResponseError?: ResponseError;
}
export declare namespace DeleteLaunchTemplateVersionsResponseErrorItem {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DeleteLaunchTemplateVersionsResponseErrorItem) => any;
}
export interface DeleteLaunchTemplateVersionsResult {
    /**
     * <p>Information about the launch template versions that were successfully
     *             deleted.</p>
     */
    SuccessfullyDeletedLaunchTemplateVersions?: DeleteLaunchTemplateVersionsResponseSuccessItem[];
    /**
     * <p>Information about the launch template versions that could not be deleted.</p>
     */
    UnsuccessfullyDeletedLaunchTemplateVersions?: DeleteLaunchTemplateVersionsResponseErrorItem[];
}
export declare namespace DeleteLaunchTemplateVersionsResult {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DeleteLaunchTemplateVersionsResult) => any;
}
export interface DeleteLocalGatewayRouteRequest {
    /**
     * <p>The CIDR range for the route. This must match the CIDR for the route exactly.</p>
     */
    DestinationCidrBlock: string | undefined;
    /**
     * <p>The ID of the local gateway route table.</p>
     */
    LocalGatewayRouteTableId: string | undefined;
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
}
export declare namespace DeleteLocalGatewayRouteRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DeleteLocalGatewayRouteRequest) => any;
}
export interface DeleteLocalGatewayRouteResult {
    /**
     * <p>Information about the route.</p>
     */
    Route?: LocalGatewayRoute;
}
export declare namespace DeleteLocalGatewayRouteResult {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DeleteLocalGatewayRouteResult) => any;
}
export interface DeleteLocalGatewayRouteTableVpcAssociationRequest {
    /**
     * <p>The ID of the association.</p>
     */
    LocalGatewayRouteTableVpcAssociationId: string | undefined;
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
}
export declare namespace DeleteLocalGatewayRouteTableVpcAssociationRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DeleteLocalGatewayRouteTableVpcAssociationRequest) => any;
}
export interface DeleteLocalGatewayRouteTableVpcAssociationResult {
    /**
     * <p>Information about the association.</p>
     */
    LocalGatewayRouteTableVpcAssociation?: LocalGatewayRouteTableVpcAssociation;
}
export declare namespace DeleteLocalGatewayRouteTableVpcAssociationResult {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DeleteLocalGatewayRouteTableVpcAssociationResult) => any;
}
export interface DeleteManagedPrefixListRequest {
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
    /**
     * <p>The ID of the prefix list.</p>
     */
    PrefixListId: string | undefined;
}
export declare namespace DeleteManagedPrefixListRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DeleteManagedPrefixListRequest) => any;
}
export interface DeleteManagedPrefixListResult {
    /**
     * <p>Information about the prefix list.</p>
     */
    PrefixList?: ManagedPrefixList;
}
export declare namespace DeleteManagedPrefixListResult {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DeleteManagedPrefixListResult) => any;
}
export interface DeleteNatGatewayRequest {
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
    /**
     * <p>The ID of the NAT gateway.</p>
     */
    NatGatewayId: string | undefined;
}
export declare namespace DeleteNatGatewayRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DeleteNatGatewayRequest) => any;
}
export interface DeleteNatGatewayResult {
    /**
     * <p>The ID of the NAT gateway.</p>
     */
    NatGatewayId?: string;
}
export declare namespace DeleteNatGatewayResult {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DeleteNatGatewayResult) => any;
}
export interface DeleteNetworkAclRequest {
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
    /**
     * <p>The ID of the network ACL.</p>
     */
    NetworkAclId: string | undefined;
}
export declare namespace DeleteNetworkAclRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DeleteNetworkAclRequest) => any;
}
export interface DeleteNetworkAclEntryRequest {
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
    /**
     * <p>Indicates whether the rule is an egress rule.</p>
     */
    Egress: boolean | undefined;
    /**
     * <p>The ID of the network ACL.</p>
     */
    NetworkAclId: string | undefined;
    /**
     * <p>The rule number of the entry to delete.</p>
     */
    RuleNumber: number | undefined;
}
export declare namespace DeleteNetworkAclEntryRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DeleteNetworkAclEntryRequest) => any;
}
export interface DeleteNetworkInsightsAccessScopeRequest {
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
    /**
     * <p>The ID of the Network Access Scope.</p>
     */
    NetworkInsightsAccessScopeId: string | undefined;
}
export declare namespace DeleteNetworkInsightsAccessScopeRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DeleteNetworkInsightsAccessScopeRequest) => any;
}
export interface DeleteNetworkInsightsAccessScopeResult {
    /**
     * <p>The ID of the Network Access Scope.</p>
     */
    NetworkInsightsAccessScopeId?: string;
}
export declare namespace DeleteNetworkInsightsAccessScopeResult {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DeleteNetworkInsightsAccessScopeResult) => any;
}
export interface DeleteNetworkInsightsAccessScopeAnalysisRequest {
    /**
     * <p>The ID of the Network Access Scope analysis.</p>
     */
    NetworkInsightsAccessScopeAnalysisId: string | undefined;
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
}
export declare namespace DeleteNetworkInsightsAccessScopeAnalysisRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DeleteNetworkInsightsAccessScopeAnalysisRequest) => any;
}
export interface DeleteNetworkInsightsAccessScopeAnalysisResult {
    /**
     * <p>The ID of the Network Access Scope analysis.</p>
     */
    NetworkInsightsAccessScopeAnalysisId?: string;
}
export declare namespace DeleteNetworkInsightsAccessScopeAnalysisResult {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DeleteNetworkInsightsAccessScopeAnalysisResult) => any;
}
export interface DeleteNetworkInsightsAnalysisRequest {
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
    /**
     * <p>The ID of the network insights analysis.</p>
     */
    NetworkInsightsAnalysisId: string | undefined;
}
export declare namespace DeleteNetworkInsightsAnalysisRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DeleteNetworkInsightsAnalysisRequest) => any;
}
export interface DeleteNetworkInsightsAnalysisResult {
    /**
     * <p>The ID of the network insights analysis.</p>
     */
    NetworkInsightsAnalysisId?: string;
}
export declare namespace DeleteNetworkInsightsAnalysisResult {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DeleteNetworkInsightsAnalysisResult) => any;
}
export interface DeleteNetworkInsightsPathRequest {
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
    /**
     * <p>The ID of the path.</p>
     */
    NetworkInsightsPathId: string | undefined;
}
export declare namespace DeleteNetworkInsightsPathRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DeleteNetworkInsightsPathRequest) => any;
}
export interface DeleteNetworkInsightsPathResult {
    /**
     * <p>The ID of the path.</p>
     */
    NetworkInsightsPathId?: string;
}
export declare namespace DeleteNetworkInsightsPathResult {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DeleteNetworkInsightsPathResult) => any;
}
/**
 * <p>Contains the parameters for DeleteNetworkInterface.</p>
 */
export interface DeleteNetworkInterfaceRequest {
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *             and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *             Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
    /**
     * <p>The ID of the network interface.</p>
     */
    NetworkInterfaceId: string | undefined;
}
export declare namespace DeleteNetworkInterfaceRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DeleteNetworkInterfaceRequest) => any;
}
/**
 * <p>Contains the parameters for DeleteNetworkInterfacePermission.</p>
 */
export interface DeleteNetworkInterfacePermissionRequest {
    /**
     * <p>The ID of the network interface permission.</p>
     */
    NetworkInterfacePermissionId: string | undefined;
    /**
     * <p>Specify <code>true</code> to remove the permission even if the network interface is
     * 			attached to an instance.</p>
     */
    Force?: boolean;
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     * 			and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     * 			Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
}
export declare namespace DeleteNetworkInterfacePermissionRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DeleteNetworkInterfacePermissionRequest) => any;
}
/**
 * <p>Contains the output for DeleteNetworkInterfacePermission.</p>
 */
export interface DeleteNetworkInterfacePermissionResult {
    /**
     * <p>Returns <code>true</code> if the request succeeds, otherwise returns an error.</p>
     */
    Return?: boolean;
}
export declare namespace DeleteNetworkInterfacePermissionResult {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DeleteNetworkInterfacePermissionResult) => any;
}
export interface DeletePlacementGroupRequest {
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
    /**
     * <p>The name of the placement group.</p>
     */
    GroupName: string | undefined;
}
export declare namespace DeletePlacementGroupRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DeletePlacementGroupRequest) => any;
}
export interface DeletePublicIpv4PoolRequest {
    /**
     * <p>A check for whether you have the required permissions for the action without actually making the request
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
    /**
     * <p>The ID of the public IPv4 pool you want to delete.</p>
     */
    PoolId: string | undefined;
}
export declare namespace DeletePublicIpv4PoolRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DeletePublicIpv4PoolRequest) => any;
}
export interface DeletePublicIpv4PoolResult {
    /**
     * <p>Information about the result of deleting the public IPv4 pool.</p>
     */
    ReturnValue?: boolean;
}
export declare namespace DeletePublicIpv4PoolResult {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DeletePublicIpv4PoolResult) => any;
}
export interface DeleteQueuedReservedInstancesRequest {
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *       and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *       Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
    /**
     * <p>The IDs of the Reserved Instances.</p>
     */
    ReservedInstancesIds: string[] | undefined;
}
export declare namespace DeleteQueuedReservedInstancesRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DeleteQueuedReservedInstancesRequest) => any;
}
export declare enum DeleteQueuedReservedInstancesErrorCode {
    RESERVED_INSTANCES_ID_INVALID = "reserved-instances-id-invalid",
    RESERVED_INSTANCES_NOT_IN_QUEUED_STATE = "reserved-instances-not-in-queued-state",
    UNEXPECTED_ERROR = "unexpected-error"
}
/**
 * <p>Describes the error for a Reserved Instance whose queued purchase could not be deleted.</p>
 */
export interface DeleteQueuedReservedInstancesError {
    /**
     * <p>The error code.</p>
     */
    Code?: DeleteQueuedReservedInstancesErrorCode | string;
    /**
     * <p>The error message.</p>
     */
    Message?: string;
}
export declare namespace DeleteQueuedReservedInstancesError {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DeleteQueuedReservedInstancesError) => any;
}
/**
 * <p>Describes a Reserved Instance whose queued purchase was not deleted.</p>
 */
export interface FailedQueuedPurchaseDeletion {
    /**
     * <p>The error.</p>
     */
    Error?: DeleteQueuedReservedInstancesError;
    /**
     * <p>The ID of the Reserved Instance.</p>
     */
    ReservedInstancesId?: string;
}
export declare namespace FailedQueuedPurchaseDeletion {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: FailedQueuedPurchaseDeletion) => any;
}
/**
 * <p>Describes a Reserved Instance whose queued purchase was successfully deleted.</p>
 */
export interface SuccessfulQueuedPurchaseDeletion {
    /**
     * <p>The ID of the Reserved Instance.</p>
     */
    ReservedInstancesId?: string;
}
export declare namespace SuccessfulQueuedPurchaseDeletion {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: SuccessfulQueuedPurchaseDeletion) => any;
}
export interface DeleteQueuedReservedInstancesResult {
    /**
     * <p>Information about the queued purchases that were successfully deleted.</p>
     */
    SuccessfulQueuedPurchaseDeletions?: SuccessfulQueuedPurchaseDeletion[];
    /**
     * <p>Information about the queued purchases that could not be deleted.</p>
     */
    FailedQueuedPurchaseDeletions?: FailedQueuedPurchaseDeletion[];
}
export declare namespace DeleteQueuedReservedInstancesResult {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DeleteQueuedReservedInstancesResult) => any;
}
export interface DeleteRouteRequest {
    /**
     * <p>The IPv4 CIDR range for the route. The value you specify must match the CIDR for the route exactly.</p>
     */
    DestinationCidrBlock?: string;
    /**
     * <p>The IPv6 CIDR range for the route. The value you specify must match the CIDR for the route exactly.</p>
     */
    DestinationIpv6CidrBlock?: string;
    /**
     * <p>The ID of the prefix list for the route.</p>
     */
    DestinationPrefixListId?: string;
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
    /**
     * <p>The ID of the route table.</p>
     */
    RouteTableId: string | undefined;
}
export declare namespace DeleteRouteRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DeleteRouteRequest) => any;
}
export interface DeleteRouteTableRequest {
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
    /**
     * <p>The ID of the route table.</p>
     */
    RouteTableId: string | undefined;
}
export declare namespace DeleteRouteTableRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DeleteRouteTableRequest) => any;
}
export interface DeleteSecurityGroupRequest {
    /**
     * <p>The ID of the security group. Required for a nondefault VPC.</p>
     */
    GroupId?: string;
    /**
     * <p>[EC2-Classic, default VPC] The name of the security group. You can specify either the security group name or the security group ID.</p>
     */
    GroupName?: string;
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
}
export declare namespace DeleteSecurityGroupRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DeleteSecurityGroupRequest) => any;
}
export interface DeleteSnapshotRequest {
    /**
     * <p>The ID of the EBS snapshot.</p>
     */
    SnapshotId: string | undefined;
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
}
export declare namespace DeleteSnapshotRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DeleteSnapshotRequest) => any;
}
/**
 * <p>Contains the parameters for DeleteSpotDatafeedSubscription.</p>
 */
export interface DeleteSpotDatafeedSubscriptionRequest {
    /**
     * <p>Checks whether you have the required permissions for the action, without actually
     *             making the request, and provides an error response. If you have the required
     *             permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is
     *                 <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
}
export declare namespace DeleteSpotDatafeedSubscriptionRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DeleteSpotDatafeedSubscriptionRequest) => any;
}
export interface DeleteSubnetRequest {
    /**
     * <p>The ID of the subnet.</p>
     */
    SubnetId: string | undefined;
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
}
export declare namespace DeleteSubnetRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DeleteSubnetRequest) => any;
}
export interface DeleteSubnetCidrReservationRequest {
    /**
     * <p>The ID of the subnet CIDR reservation.</p>
     */
    SubnetCidrReservationId: string | undefined;
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
}
export declare namespace DeleteSubnetCidrReservationRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DeleteSubnetCidrReservationRequest) => any;
}
export interface DeleteSubnetCidrReservationResult {
    /**
     * <p>Information about the deleted subnet CIDR reservation.</p>
     */
    DeletedSubnetCidrReservation?: SubnetCidrReservation;
}
export declare namespace DeleteSubnetCidrReservationResult {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DeleteSubnetCidrReservationResult) => any;
}
export interface DeleteTagsRequest {
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
    /**
     * <p>The IDs of the resources, separated by spaces.</p>
     *    	     <p>Constraints: Up to 1000 resource IDs. We recommend breaking up this request into smaller batches.</p>
     */
    Resources: string[] | undefined;
    /**
     * <p>The tags to delete. Specify a tag key and an optional tag value to delete
     *             specific tags. If you specify a tag key without a tag value, we delete any tag with this
     *             key regardless of its value. If you specify a tag key with an empty string as the tag
     *             value, we delete the tag only if its value is an empty string.</p>
     *         <p>If you omit this parameter, we delete all user-defined tags for the specified
     *             resources. We do not delete Amazon Web Services-generated tags (tags that have the <code>aws:</code>
     *             prefix).</p>
     *          <p>Constraints: Up to 1000 tags.</p>
     */
    Tags?: Tag[];
}
export declare namespace DeleteTagsRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DeleteTagsRequest) => any;
}
export interface DeleteTrafficMirrorFilterRequest {
    /**
     * <p>The ID of the Traffic Mirror filter.</p>
     */
    TrafficMirrorFilterId: string | undefined;
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
}
export declare namespace DeleteTrafficMirrorFilterRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DeleteTrafficMirrorFilterRequest) => any;
}
export interface DeleteTrafficMirrorFilterResult {
    /**
     * <p>The ID of the Traffic Mirror filter.</p>
     */
    TrafficMirrorFilterId?: string;
}
export declare namespace DeleteTrafficMirrorFilterResult {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DeleteTrafficMirrorFilterResult) => any;
}
export interface DeleteTrafficMirrorFilterRuleRequest {
    /**
     * <p>The ID of the Traffic Mirror rule.</p>
     */
    TrafficMirrorFilterRuleId: string | undefined;
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
}
export declare namespace DeleteTrafficMirrorFilterRuleRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DeleteTrafficMirrorFilterRuleRequest) => any;
}
export interface DeleteTrafficMirrorFilterRuleResult {
    /**
     * <p>The ID of the deleted Traffic Mirror rule.</p>
     */
    TrafficMirrorFilterRuleId?: string;
}
export declare namespace DeleteTrafficMirrorFilterRuleResult {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DeleteTrafficMirrorFilterRuleResult) => any;
}
export interface DeleteTrafficMirrorSessionRequest {
    /**
     * <p>The ID of the Traffic Mirror session.</p>
     */
    TrafficMirrorSessionId: string | undefined;
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
}
export declare namespace DeleteTrafficMirrorSessionRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DeleteTrafficMirrorSessionRequest) => any;
}
export interface DeleteTrafficMirrorSessionResult {
    /**
     * <p>The ID of the deleted Traffic Mirror session.</p>
     */
    TrafficMirrorSessionId?: string;
}
export declare namespace DeleteTrafficMirrorSessionResult {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DeleteTrafficMirrorSessionResult) => any;
}
export interface DeleteTrafficMirrorTargetRequest {
    /**
     * <p>The ID of the Traffic Mirror target.</p>
     */
    TrafficMirrorTargetId: string | undefined;
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
}
export declare namespace DeleteTrafficMirrorTargetRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DeleteTrafficMirrorTargetRequest) => any;
}
export interface DeleteTrafficMirrorTargetResult {
    /**
     * <p>The ID of the deleted Traffic Mirror target.</p>
     */
    TrafficMirrorTargetId?: string;
}
export declare namespace DeleteTrafficMirrorTargetResult {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DeleteTrafficMirrorTargetResult) => any;
}
export interface DeleteTransitGatewayRequest {
    /**
     * <p>The ID of the transit gateway.</p>
     */
    TransitGatewayId: string | undefined;
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
}
export declare namespace DeleteTransitGatewayRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DeleteTransitGatewayRequest) => any;
}
export interface DeleteTransitGatewayResult {
    /**
     * <p>Information about the deleted transit gateway.</p>
     */
    TransitGateway?: TransitGateway;
}
export declare namespace DeleteTransitGatewayResult {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DeleteTransitGatewayResult) => any;
}
export interface DeleteTransitGatewayConnectRequest {
    /**
     * <p>The ID of the Connect attachment.</p>
     */
    TransitGatewayAttachmentId: string | undefined;
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
}
export declare namespace DeleteTransitGatewayConnectRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DeleteTransitGatewayConnectRequest) => any;
}
export interface DeleteTransitGatewayConnectResult {
    /**
     * <p>Information about the deleted Connect attachment.</p>
     */
    TransitGatewayConnect?: TransitGatewayConnect;
}
export declare namespace DeleteTransitGatewayConnectResult {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DeleteTransitGatewayConnectResult) => any;
}
export interface DeleteTransitGatewayConnectPeerRequest {
    /**
     * <p>The ID of the Connect peer.</p>
     */
    TransitGatewayConnectPeerId: string | undefined;
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
}
export declare namespace DeleteTransitGatewayConnectPeerRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DeleteTransitGatewayConnectPeerRequest) => any;
}
export interface DeleteTransitGatewayConnectPeerResult {
    /**
     * <p>Information about the deleted Connect peer.</p>
     */
    TransitGatewayConnectPeer?: TransitGatewayConnectPeer;
}
export declare namespace DeleteTransitGatewayConnectPeerResult {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DeleteTransitGatewayConnectPeerResult) => any;
}
export interface DeleteTransitGatewayMulticastDomainRequest {
    /**
     * <p>The ID of the transit gateway multicast domain.</p>
     */
    TransitGatewayMulticastDomainId: string | undefined;
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
}
export declare namespace DeleteTransitGatewayMulticastDomainRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DeleteTransitGatewayMulticastDomainRequest) => any;
}
export interface DeleteTransitGatewayMulticastDomainResult {
    /**
     * <p>Information about the deleted transit gateway multicast domain.</p>
     */
    TransitGatewayMulticastDomain?: TransitGatewayMulticastDomain;
}
export declare namespace DeleteTransitGatewayMulticastDomainResult {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DeleteTransitGatewayMulticastDomainResult) => any;
}
export interface DeleteTransitGatewayPeeringAttachmentRequest {
    /**
     * <p>The ID of the transit gateway peering attachment.</p>
     */
    TransitGatewayAttachmentId: string | undefined;
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
}
export declare namespace DeleteTransitGatewayPeeringAttachmentRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DeleteTransitGatewayPeeringAttachmentRequest) => any;
}
export interface DeleteTransitGatewayPeeringAttachmentResult {
    /**
     * <p>The transit gateway peering attachment.</p>
     */
    TransitGatewayPeeringAttachment?: TransitGatewayPeeringAttachment;
}
export declare namespace DeleteTransitGatewayPeeringAttachmentResult {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DeleteTransitGatewayPeeringAttachmentResult) => any;
}
export interface DeleteTransitGatewayPrefixListReferenceRequest {
    /**
     * <p>The ID of the route table.</p>
     */
    TransitGatewayRouteTableId: string | undefined;
    /**
     * <p>The ID of the prefix list.</p>
     */
    PrefixListId: string | undefined;
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
}
export declare namespace DeleteTransitGatewayPrefixListReferenceRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DeleteTransitGatewayPrefixListReferenceRequest) => any;
}
export interface DeleteTransitGatewayPrefixListReferenceResult {
    /**
     * <p>Information about the deleted prefix list reference.</p>
     */
    TransitGatewayPrefixListReference?: TransitGatewayPrefixListReference;
}
export declare namespace DeleteTransitGatewayPrefixListReferenceResult {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DeleteTransitGatewayPrefixListReferenceResult) => any;
}
export interface DeleteTransitGatewayRouteRequest {
    /**
     * <p>The ID of the transit gateway route table.</p>
     */
    TransitGatewayRouteTableId: string | undefined;
    /**
     * <p>The CIDR range for the route. This must match the CIDR for the route exactly.</p>
     */
    DestinationCidrBlock: string | undefined;
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
}
export declare namespace DeleteTransitGatewayRouteRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DeleteTransitGatewayRouteRequest) => any;
}
export interface DeleteTransitGatewayRouteResult {
    /**
     * <p>Information about the route.</p>
     */
    Route?: TransitGatewayRoute;
}
export declare namespace DeleteTransitGatewayRouteResult {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DeleteTransitGatewayRouteResult) => any;
}
export interface DeleteTransitGatewayRouteTableRequest {
    /**
     * <p>The ID of the transit gateway route table.</p>
     */
    TransitGatewayRouteTableId: string | undefined;
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
}
export declare namespace DeleteTransitGatewayRouteTableRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DeleteTransitGatewayRouteTableRequest) => any;
}
export interface DeleteTransitGatewayRouteTableResult {
    /**
     * <p>Information about the deleted transit gateway route table.</p>
     */
    TransitGatewayRouteTable?: TransitGatewayRouteTable;
}
export declare namespace DeleteTransitGatewayRouteTableResult {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DeleteTransitGatewayRouteTableResult) => any;
}
export interface DeleteTransitGatewayVpcAttachmentRequest {
    /**
     * <p>The ID of the attachment.</p>
     */
    TransitGatewayAttachmentId: string | undefined;
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
}
export declare namespace DeleteTransitGatewayVpcAttachmentRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DeleteTransitGatewayVpcAttachmentRequest) => any;
}
export interface DeleteTransitGatewayVpcAttachmentResult {
    /**
     * <p>Information about the deleted VPC attachment.</p>
     */
    TransitGatewayVpcAttachment?: TransitGatewayVpcAttachment;
}
export declare namespace DeleteTransitGatewayVpcAttachmentResult {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DeleteTransitGatewayVpcAttachmentResult) => any;
}
export interface DeleteVolumeRequest {
    /**
     * <p>The ID of the volume.</p>
     */
    VolumeId: string | undefined;
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
}
export declare namespace DeleteVolumeRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DeleteVolumeRequest) => any;
}
export interface DeleteVpcRequest {
    /**
     * <p>The ID of the VPC.</p>
     */
    VpcId: string | undefined;
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
}
export declare namespace DeleteVpcRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DeleteVpcRequest) => any;
}
export interface DeleteVpcEndpointConnectionNotificationsRequest {
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
    /**
     * <p>One or more notification IDs.</p>
     */
    ConnectionNotificationIds: string[] | undefined;
}
export declare namespace DeleteVpcEndpointConnectionNotificationsRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DeleteVpcEndpointConnectionNotificationsRequest) => any;
}
export interface DeleteVpcEndpointConnectionNotificationsResult {
    /**
     * <p>Information about the notifications that could not be deleted
     *             successfully.</p>
     */
    Unsuccessful?: UnsuccessfulItem[];
}
export declare namespace DeleteVpcEndpointConnectionNotificationsResult {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DeleteVpcEndpointConnectionNotificationsResult) => any;
}
/**
 * <p>Contains the parameters for DeleteVpcEndpoints.</p>
 */
export interface DeleteVpcEndpointsRequest {
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
    /**
     * <p>One or more VPC endpoint IDs.</p>
     */
    VpcEndpointIds: string[] | undefined;
}
export declare namespace DeleteVpcEndpointsRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DeleteVpcEndpointsRequest) => any;
}
/**
 * <p>Contains the output of DeleteVpcEndpoints.</p>
 */
export interface DeleteVpcEndpointsResult {
    /**
     * <p>Information about the VPC endpoints that were not successfully deleted.</p>
     */
    Unsuccessful?: UnsuccessfulItem[];
}
export declare namespace DeleteVpcEndpointsResult {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DeleteVpcEndpointsResult) => any;
}
export interface DeleteVpcEndpointServiceConfigurationsRequest {
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
    /**
     * <p>The IDs of one or more services.</p>
     */
    ServiceIds: string[] | undefined;
}
export declare namespace DeleteVpcEndpointServiceConfigurationsRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DeleteVpcEndpointServiceConfigurationsRequest) => any;
}
export interface DeleteVpcEndpointServiceConfigurationsResult {
    /**
     * <p>Information about the service configurations that were not deleted, if
     *             applicable.</p>
     */
    Unsuccessful?: UnsuccessfulItem[];
}
export declare namespace DeleteVpcEndpointServiceConfigurationsResult {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DeleteVpcEndpointServiceConfigurationsResult) => any;
}
export interface DeleteVpcPeeringConnectionRequest {
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
    /**
     * <p>The ID of the VPC peering connection.</p>
     */
    VpcPeeringConnectionId: string | undefined;
}
export declare namespace DeleteVpcPeeringConnectionRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DeleteVpcPeeringConnectionRequest) => any;
}
export interface DeleteVpcPeeringConnectionResult {
    /**
     * <p>Returns <code>true</code> if the request succeeds; otherwise, it returns an error.</p>
     */
    Return?: boolean;
}
export declare namespace DeleteVpcPeeringConnectionResult {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DeleteVpcPeeringConnectionResult) => any;
}
/**
 * <p>Contains the parameters for DeleteVpnConnection.</p>
 */
export interface DeleteVpnConnectionRequest {
    /**
     * <p>The ID of the VPN connection.</p>
     */
    VpnConnectionId: string | undefined;
    /**
     * <p>Checks whether you have the required permissions for the action, without actually
     *             making the request, and provides an error response. If you have the required
     *             permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is
     *                 <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
}
export declare namespace DeleteVpnConnectionRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DeleteVpnConnectionRequest) => any;
}
/**
 * <p>Contains the parameters for DeleteVpnConnectionRoute.</p>
 */
export interface DeleteVpnConnectionRouteRequest {
    /**
     * <p>The CIDR block associated with the local subnet of the customer network.</p>
     */
    DestinationCidrBlock: string | undefined;
    /**
     * <p>The ID of the VPN connection.</p>
     */
    VpnConnectionId: string | undefined;
}
export declare namespace DeleteVpnConnectionRouteRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DeleteVpnConnectionRouteRequest) => any;
}
/**
 * <p>Contains the parameters for DeleteVpnGateway.</p>
 */
export interface DeleteVpnGatewayRequest {
    /**
     * <p>The ID of the virtual private gateway.</p>
     */
    VpnGatewayId: string | undefined;
    /**
     * <p>Checks whether you have the required permissions for the action, without actually
     *             making the request, and provides an error response. If you have the required
     *             permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is
     *                 <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
}
export declare namespace DeleteVpnGatewayRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DeleteVpnGatewayRequest) => any;
}
export interface DeprovisionByoipCidrRequest {
    /**
     * <p>The address range, in CIDR notation. The prefix must be the same prefix
     *          that you specified when you provisioned the address range.</p>
     */
    Cidr: string | undefined;
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
}
export declare namespace DeprovisionByoipCidrRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DeprovisionByoipCidrRequest) => any;
}
export interface DeprovisionByoipCidrResult {
    /**
     * <p>Information about the address range.</p>
     */
    ByoipCidr?: ByoipCidr;
}
export declare namespace DeprovisionByoipCidrResult {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DeprovisionByoipCidrResult) => any;
}
export interface DeprovisionIpamPoolCidrRequest {
    /**
     * <p>A check for whether you have the required permissions for the action without actually making the request
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
    /**
     * <p>The ID of the pool that has the CIDR you want to deprovision.</p>
     */
    IpamPoolId: string | undefined;
    /**
     * <p>The CIDR which you want to deprovision from the pool.</p>
     */
    Cidr?: string;
}
export declare namespace DeprovisionIpamPoolCidrRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DeprovisionIpamPoolCidrRequest) => any;
}
export declare enum IpamPoolCidrFailureCode {
    cidr_not_available = "cidr-not-available"
}
/**
 * <p>Details related to why an IPAM pool CIDR failed to be provisioned.</p>
 */
export interface IpamPoolCidrFailureReason {
    /**
     * <p>An error code related to why an IPAM pool CIDR failed to be provisioned.</p>
     */
    Code?: IpamPoolCidrFailureCode | string;
    /**
     * <p>A message related to why an IPAM pool CIDR failed to be provisioned.</p>
     */
    Message?: string;
}
export declare namespace IpamPoolCidrFailureReason {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: IpamPoolCidrFailureReason) => any;
}
export declare enum IpamPoolCidrState {
    deprovisioned = "deprovisioned",
    failed_deprovision = "failed-deprovision",
    failed_import = "failed-import",
    failed_provision = "failed-provision",
    pending_deprovision = "pending-deprovision",
    pending_import = "pending-import",
    pending_provision = "pending-provision",
    provisioned = "provisioned"
}
/**
 * <p>A CIDR provisioned to an IPAM pool.</p>
 */
export interface IpamPoolCidr {
    /**
     * <p>The CIDR provisioned to the IPAM pool. A CIDR is a representation of an IP address and its associated network mask (or netmask)
     *          and refers to a range of IP addresses. An IPv4 CIDR example is <code>10.24.34.0/23</code>. An IPv6 CIDR example is <code>2001:DB8::/32</code>.</p>
     */
    Cidr?: string;
    /**
     * <p>The state of the CIDR.</p>
     */
    State?: IpamPoolCidrState | string;
    /**
     * <p>Details related to why an IPAM pool CIDR failed to be provisioned.</p>
     */
    FailureReason?: IpamPoolCidrFailureReason;
}
export declare namespace IpamPoolCidr {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: IpamPoolCidr) => any;
}
export interface DeprovisionIpamPoolCidrResult {
    /**
     * <p>The deprovisioned pool CIDR.</p>
     */
    IpamPoolCidr?: IpamPoolCidr;
}
export declare namespace DeprovisionIpamPoolCidrResult {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DeprovisionIpamPoolCidrResult) => any;
}
export interface DeprovisionPublicIpv4PoolCidrRequest {
    /**
     * <p>A check for whether you have the required permissions for the action without actually making the request
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
    /**
     * <p>The ID of the pool that you want to deprovision the CIDR from.</p>
     */
    PoolId: string | undefined;
    /**
     * <p>The CIDR you want to deprovision from the pool.</p>
     */
    Cidr: string | undefined;
}
export declare namespace DeprovisionPublicIpv4PoolCidrRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DeprovisionPublicIpv4PoolCidrRequest) => any;
}
export interface DeprovisionPublicIpv4PoolCidrResult {
    /**
     * <p>The ID of the pool that you deprovisioned the CIDR from.</p>
     */
    PoolId?: string;
    /**
     * <p>The deprovisioned CIDRs.</p>
     */
    DeprovisionedAddresses?: string[];
}
export declare namespace DeprovisionPublicIpv4PoolCidrResult {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DeprovisionPublicIpv4PoolCidrResult) => any;
}
/**
 * <p>Contains the parameters for DeregisterImage.</p>
 */
export interface DeregisterImageRequest {
    /**
     * <p>The ID of the AMI.</p>
     */
    ImageId: string | undefined;
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *        and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *        Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
}
export declare namespace DeregisterImageRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DeregisterImageRequest) => any;
}
/**
 * <p>Information about the tag keys to deregister for the current Region. You can either specify
 *    		individual tag keys or deregister all tag keys in the current Region. You must specify either
 *    		<code>IncludeAllTagsOfInstance</code> or <code>InstanceTagKeys</code> in the request</p>
 */
export interface DeregisterInstanceTagAttributeRequest {
    /**
     * <p>Indicates whether to deregister all tag keys in the current Region. Specify <code>false</code>
     *    		to deregister all tag keys.</p>
     */
    IncludeAllTagsOfInstance?: boolean;
    /**
     * <p>Information about the tag keys to deregister.</p>
     */
    InstanceTagKeys?: string[];
}
export declare namespace DeregisterInstanceTagAttributeRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DeregisterInstanceTagAttributeRequest) => any;
}
export interface DeregisterInstanceEventNotificationAttributesRequest {
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
    /**
     * <p>Information about the tag keys to deregister.</p>
     */
    InstanceTagAttribute?: DeregisterInstanceTagAttributeRequest;
}
export declare namespace DeregisterInstanceEventNotificationAttributesRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DeregisterInstanceEventNotificationAttributesRequest) => any;
}
/**
 * <p>Describes the registered tag keys for the current Region.</p>
 */
export interface InstanceTagNotificationAttribute {
    /**
     * <p>The registered tag keys.</p>
     */
    InstanceTagKeys?: string[];
    /**
     * <p>Indicates wheter all tag keys in the current Region are registered to appear in scheduled event notifications.
     *       	<code>true</code> indicates that all tag keys in the current Region are registered.</p>
     */
    IncludeAllTagsOfInstance?: boolean;
}
export declare namespace InstanceTagNotificationAttribute {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: InstanceTagNotificationAttribute) => any;
}
export interface DeregisterInstanceEventNotificationAttributesResult {
    /**
     * <p>The resulting set of tag keys.</p>
     */
    InstanceTagAttribute?: InstanceTagNotificationAttribute;
}
export declare namespace DeregisterInstanceEventNotificationAttributesResult {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DeregisterInstanceEventNotificationAttributesResult) => any;
}
export interface DeregisterTransitGatewayMulticastGroupMembersRequest {
    /**
     * <p>The ID of the transit gateway multicast domain.</p>
     */
    TransitGatewayMulticastDomainId?: string;
    /**
     * <p>The IP address assigned to the  transit gateway multicast group.</p>
     */
    GroupIpAddress?: string;
    /**
     * <p>The IDs of the group members' network interfaces.</p>
     */
    NetworkInterfaceIds?: string[];
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
}
export declare namespace DeregisterTransitGatewayMulticastGroupMembersRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DeregisterTransitGatewayMulticastGroupMembersRequest) => any;
}
/**
 * <p>Describes the deregistered  transit gateway multicast group members.</p>
 */
export interface TransitGatewayMulticastDeregisteredGroupMembers {
    /**
     * <p>The ID of the transit gateway multicast domain.</p>
     */
    TransitGatewayMulticastDomainId?: string;
    /**
     * <p>The network interface IDs of the deregistered members.</p>
     */
    DeregisteredNetworkInterfaceIds?: string[];
    /**
     * <p>The IP address assigned to the  transit gateway multicast group.</p>
     */
    GroupIpAddress?: string;
}
export declare namespace TransitGatewayMulticastDeregisteredGroupMembers {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: TransitGatewayMulticastDeregisteredGroupMembers) => any;
}
export interface DeregisterTransitGatewayMulticastGroupMembersResult {
    /**
     * <p>Information about the deregistered members.</p>
     */
    DeregisteredMulticastGroupMembers?: TransitGatewayMulticastDeregisteredGroupMembers;
}
export declare namespace DeregisterTransitGatewayMulticastGroupMembersResult {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DeregisterTransitGatewayMulticastGroupMembersResult) => any;
}
export interface DeregisterTransitGatewayMulticastGroupSourcesRequest {
    /**
     * <p>The ID of the transit gateway multicast domain.</p>
     */
    TransitGatewayMulticastDomainId?: string;
    /**
     * <p>The IP address assigned to the  transit gateway multicast group.</p>
     */
    GroupIpAddress?: string;
    /**
     * <p>The IDs of the group sources' network interfaces.</p>
     */
    NetworkInterfaceIds?: string[];
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
}
export declare namespace DeregisterTransitGatewayMulticastGroupSourcesRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DeregisterTransitGatewayMulticastGroupSourcesRequest) => any;
}
/**
 * <p>Describes the deregistered  transit gateway multicast group sources.</p>
 */
export interface TransitGatewayMulticastDeregisteredGroupSources {
    /**
     * <p>The ID of the transit gateway multicast domain.</p>
     */
    TransitGatewayMulticastDomainId?: string;
    /**
     * <p>The network interface IDs of the non-registered members.</p>
     */
    DeregisteredNetworkInterfaceIds?: string[];
    /**
     * <p>The IP address assigned to the  transit gateway multicast group.</p>
     */
    GroupIpAddress?: string;
}
export declare namespace TransitGatewayMulticastDeregisteredGroupSources {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: TransitGatewayMulticastDeregisteredGroupSources) => any;
}
export interface DeregisterTransitGatewayMulticastGroupSourcesResult {
    /**
     * <p>Information about the deregistered group sources.</p>
     */
    DeregisteredMulticastGroupSources?: TransitGatewayMulticastDeregisteredGroupSources;
}
export declare namespace DeregisterTransitGatewayMulticastGroupSourcesResult {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DeregisterTransitGatewayMulticastGroupSourcesResult) => any;
}
export interface DescribeAccountAttributesRequest {
    /**
     * <p>The account attribute names.</p>
     */
    AttributeNames?: (AccountAttributeName | string)[];
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *            and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *            Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
}
export declare namespace DescribeAccountAttributesRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DescribeAccountAttributesRequest) => any;
}
export interface DescribeAccountAttributesResult {
    /**
     * <p>Information about the account attributes.</p>
     */
    AccountAttributes?: AccountAttribute[];
}
export declare namespace DescribeAccountAttributesResult {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DescribeAccountAttributesResult) => any;
}
/**
 * <p>A filter name and value pair that is used to return a more specific list of results from a describe operation.
 *          Filters can be used to match a set of resources by specific criteria, such as tags, attributes, or IDs.</p>
 */
export interface Filter {
    /**
     * <p>The name of the filter. Filter names are case-sensitive.</p>
     */
    Name?: string;
    /**
     * <p>The filter values. Filter values are case-sensitive.</p>
     */
    Values?: string[];
}
export declare namespace Filter {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: Filter) => any;
}
export interface DescribeAddressesRequest {
    /**
     * <p>One or more filters. Filter names and values are case-sensitive.</p>
     *          <ul>
     *             <li>
     *                <p>
     *                   <code>allocation-id</code> - [EC2-VPC] The allocation ID for the address.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>association-id</code> - [EC2-VPC] The association ID for the address.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>domain</code> - Indicates whether the address is for use in EC2-Classic (<code>standard</code>)
     *               or in a VPC (<code>vpc</code>).</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>instance-id</code> - The ID of the instance the address is associated with, if any.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>network-border-group</code> -  A unique set of Availability Zones, Local Zones,
     *            or Wavelength Zones from where Amazon Web Services advertises IP addresses. </p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>network-interface-id</code> - [EC2-VPC] The ID of the network interface that the address is associated with, if any.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>network-interface-owner-id</code> - The Amazon Web Services account ID of the owner.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>private-ip-address</code> - [EC2-VPC] The private IP address associated with the Elastic IP address.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>public-ip</code> - The Elastic IP address, or the carrier IP address.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>tag</code>:<key> - The key/value combination of a tag assigned to the resource. Use the tag key in the filter name and the tag value as the filter value.
     *     For example, to find all resources that have a tag with the key <code>Owner</code> and the value <code>TeamA</code>, specify <code>tag:Owner</code> for the filter name and <code>TeamA</code> for the filter value.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all resources assigned a tag with a specific key, regardless of the tag value.</p>
     *             </li>
     *          </ul>
     */
    Filters?: Filter[];
    /**
     * <p>One or more Elastic IP addresses.</p>
     *          <p>Default: Describes all your Elastic IP addresses.</p>
     */
    PublicIps?: string[];
    /**
     * <p>[EC2-VPC] Information about the allocation IDs.</p>
     */
    AllocationIds?: string[];
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
}
export declare namespace DescribeAddressesRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DescribeAddressesRequest) => any;
}
export interface DescribeAddressesResult {
    /**
     * <p>Information about the Elastic IP addresses.</p>
     */
    Addresses?: Address[];
}
export declare namespace DescribeAddressesResult {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DescribeAddressesResult) => any;
}
export interface DescribeAddressesAttributeRequest {
    /**
     * <p>[EC2-VPC] The allocation IDs.</p>
     */
    AllocationIds?: string[];
    /**
     * <p>The attribute of the IP address.</p>
     */
    Attribute?: AddressAttributeName | string;
    /**
     * <p>The token for the next page of results.</p>
     */
    NextToken?: string;
    /**
     * <p>The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
     */
    MaxResults?: number;
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
}
export declare namespace DescribeAddressesAttributeRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DescribeAddressesAttributeRequest) => any;
}
export interface DescribeAddressesAttributeResult {
    /**
     * <p>Information about the IP addresses.</p>
     */
    Addresses?: AddressAttribute[];
    /**
     * <p>The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
     */
    NextToken?: string;
}
export declare namespace DescribeAddressesAttributeResult {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DescribeAddressesAttributeResult) => any;
}
export interface DescribeAggregateIdFormatRequest {
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
}
export declare namespace DescribeAggregateIdFormatRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DescribeAggregateIdFormatRequest) => any;
}
/**
 * <p>Describes the ID format for a resource.</p>
 */
export interface IdFormat {
    /**
     * <p>The date in UTC at which you are permanently switched over to using longer IDs. If a deadline is not yet available for this resource type, this field is not returned.</p>
     */
    Deadline?: Date;
    /**
     * <p>The type of resource.</p>
     */
    Resource?: string;
    /**
     * <p>Indicates whether longer IDs (17-character IDs) are enabled for the resource.</p>
     */
    UseLongIds?: boolean;
}
export declare namespace IdFormat {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: IdFormat) => any;
}
export interface DescribeAggregateIdFormatResult {
    /**
     * <p>Indicates whether all resource types in the Region are configured to use longer IDs.
     *             This value is only <code>true</code> if all users are configured to use longer IDs for
     *             all resources types in the Region.</p>
     */
    UseLongIdsAggregated?: boolean;
    /**
     * <p>Information about each resource's ID format.</p>
     */
    Statuses?: IdFormat[];
}
export declare namespace DescribeAggregateIdFormatResult {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DescribeAggregateIdFormatResult) => any;
}
export interface DescribeAvailabilityZonesRequest {
    /**
     * <p>The filters.</p>
     *          <ul>
     *             <li>
     *                <p>
     *                   <code>group-name</code> - For Availability Zones, use the Region name. For Local
     *           Zones, use the name of the group associated with the Local Zone (for example,
     *             <code>us-west-2-lax-1</code>) For Wavelength Zones, use the name of the group associated
     *           with the Wavelength Zone (for example, <code>us-east-1-wl1-bos-wlz-1</code>).</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>message</code> - The Zone message.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>opt-in-status</code> - The opt-in status (<code>opted-in</code>, and
     *             <code>not-opted-in</code> | <code>opt-in-not-required</code>).</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>parent-zoneID</code> - The ID of the zone that handles some of the Local Zone
     *           and Wavelength Zone control plane operations, such as API calls.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>parent-zoneName</code> - The ID of the zone that handles some of the Local Zone
     *           and Wavelength Zone control plane operations, such as API calls.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>region-name</code> - The name of the Region for the Zone (for example,
     *             <code>us-east-1</code>).</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>state</code> - The state of the Availability Zone, the Local Zone, or the
     *           Wavelength Zone (<code>available</code> | <code>information</code> | <code>impaired</code>
     *           | <code>unavailable</code>).</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>zone-id</code> - The ID of the Availability Zone (for example,
     *             <code>use1-az1</code>), the Local Zone (for example, <code>usw2-lax1-az1</code>), or the
     *           Wavelength Zone (for example, <code>us-east-1-wl1-bos-wlz-1</code>).</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>zone-type</code> - The type of zone, for example, <code>local-zone</code>.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>zone-name</code> - The name of the Availability Zone (for example,
     *             <code>us-east-1a</code>), the Local Zone (for example, <code>us-west-2-lax-1a</code>), or
     *           the Wavelength Zone (for example, <code>us-east-1-wl1-bos-wlz-1</code>).</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>zone-type</code> - The type of zone, for example, <code>local-zone</code>.</p>
     *             </li>
     *          </ul>
     */
    Filters?: Filter[];
    /**
     * <p>The names of the Availability Zones, Local Zones, and Wavelength Zones.</p>
     */
    ZoneNames?: string[];
    /**
     * <p>The IDs of the Availability Zones, Local Zones, and Wavelength Zones.</p>
     */
    ZoneIds?: string[];
    /**
     * <p>Include all Availability Zones, Local Zones, and Wavelength Zones regardless of your
     *       opt-in status.</p>
     *          <p>If you do not use this parameter, the results include only the zones for the Regions where you have chosen the option to opt in.</p>
     */
    AllAvailabilityZones?: boolean;
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
}
export declare namespace DescribeAvailabilityZonesRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DescribeAvailabilityZonesRequest) => any;
}
/**
 * <p>Describes a message about an Availability Zone, Local Zone, or Wavelength Zone.</p>
 */
export interface AvailabilityZoneMessage {
    /**
     * <p>The message about the Availability Zone, Local Zone, or Wavelength Zone.</p>
     */
    Message?: string;
}
export declare namespace AvailabilityZoneMessage {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: AvailabilityZoneMessage) => any;
}
export declare type AvailabilityZoneOptInStatus = "not-opted-in" | "opt-in-not-required" | "opted-in";
export declare type AvailabilityZoneState = "available" | "impaired" | "information" | "unavailable";
/**
 * <p>Describes Availability Zones, Local Zones, and Wavelength Zones.</p>
 */
export interface AvailabilityZone {
    /**
     * <p>The state of the Availability Zone, Local Zone, or Wavelength Zone.</p>
     */
    State?: AvailabilityZoneState | string;
    /**
     * <p>For Availability Zones, this parameter always has the value of
     *         <code>opt-in-not-required</code>.</p>
     *          <p>For Local Zones and Wavelength Zones, this parameter is the opt-in status. The possible
     *       values are <code>opted-in</code>, and <code>not-opted-in</code>.</p>
     */
    OptInStatus?: AvailabilityZoneOptInStatus | string;
    /**
     * <p>Any messages about the Availability Zone, Local Zone, or Wavelength Zone.</p>
     */
    Messages?: AvailabilityZoneMessage[];
    /**
     * <p>The name of the Region.</p>
     */
    RegionName?: string;
    /**
     * <p>The name of the Availability Zone, Local Zone, or Wavelength Zone.</p>
     */
    ZoneName?: string;
    /**
     * <p>The ID of the Availability Zone, Local Zone, or Wavelength Zone.</p>
     */
    ZoneId?: string;
    /**
     * <p> For Availability Zones, this parameter has the same value as the Region name.</p>
     *          <p>For Local Zones, the name of the associated group, for example
     *         <code>us-west-2-lax-1</code>.</p>
     *          <p>For Wavelength Zones, the name of the associated group, for example
     *         <code>us-east-1-wl1-bos-wlz-1</code>.</p>
     */
    GroupName?: string;
    /**
     * <p>The name of the network border group.</p>
     */
    NetworkBorderGroup?: string;
    /**
     * <p>The type of zone. The valid values are <code>availability-zone</code>,
     *         <code>local-zone</code>, and <code>wavelength-zone</code>.</p>
     */
    ZoneType?: string;
    /**
     * <p>The name of the zone that handles some of the Local Zone or Wavelength Zone control plane
     *       operations, such as API calls.</p>
     */
    ParentZoneName?: string;
    /**
     * <p>The ID of the zone that handles some of the Local Zone or Wavelength Zone control plane
     *       operations, such as API calls.</p>
     */
    ParentZoneId?: string;
}
export declare namespace AvailabilityZone {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: AvailabilityZone) => any;
}
export interface DescribeAvailabilityZonesResult {
    /**
     * <p>Information about the Availability Zones, Local Zones, and Wavelength Zones.</p>
     */
    AvailabilityZones?: AvailabilityZone[];
}
export declare namespace DescribeAvailabilityZonesResult {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DescribeAvailabilityZonesResult) => any;
}
export interface DescribeBundleTasksRequest {
    /**
     * <p>The bundle task IDs.</p>
     *          <p>Default: Describes all your bundle tasks.</p>
     */
    BundleIds?: string[];
    /**
     * <p>The filters.</p>
     *          <ul>
     *             <li>
     *                <p>
     *                   <code>bundle-id</code> - The ID of the bundle task.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>error-code</code> - If the task failed, the error code returned.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>error-message</code> - If the task failed, the error message returned.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>instance-id</code> - The ID of the instance.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>progress</code> - The level of task completion, as a percentage (for example, 20%).</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>s3-bucket</code> - The Amazon S3 bucket to store the AMI.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>s3-prefix</code> - The beginning of the AMI name.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>start-time</code> - The time the task started (for example, 2013-09-15T17:15:20.000Z).</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>state</code> - The state of the task (<code>pending</code> | <code>waiting-for-shutdown</code> | <code>bundling</code> |
     *            <code>storing</code> | <code>cancelling</code> | <code>complete</code> | <code>failed</code>).</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>update-time</code> - The time of the most recent update for the task.</p>
     *             </li>
     *          </ul>
     */
    Filters?: Filter[];
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *        and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *        Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
}
export declare namespace DescribeBundleTasksRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DescribeBundleTasksRequest) => any;
}
export interface DescribeBundleTasksResult {
    /**
     * <p>Information about the bundle tasks.</p>
     */
    BundleTasks?: BundleTask[];
}
export declare namespace DescribeBundleTasksResult {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DescribeBundleTasksResult) => any;
}
export interface DescribeByoipCidrsRequest {
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
    /**
     * <p>The maximum number of results to return with a single call.
     * 	To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
     */
    MaxResults: number | undefined;
    /**
     * <p>The token for the next page of results.</p>
     */
    NextToken?: string;
}
export declare namespace DescribeByoipCidrsRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DescribeByoipCidrsRequest) => any;
}
export interface DescribeByoipCidrsResult {
    /**
     * <p>Information about your address ranges.</p>
     */
    ByoipCidrs?: ByoipCidr[];
    /**
     * <p>The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
     */
    NextToken?: string;
}
export declare namespace DescribeByoipCidrsResult {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DescribeByoipCidrsResult) => any;
}
export interface DescribeCapacityReservationFleetsRequest {
    /**
     * <p>The IDs of the Capacity Reservation Fleets to describe.</p>
     */
    CapacityReservationFleetIds?: string[];
    /**
     * <p>The token to use to retrieve the next page of results.</p>
     */
    NextToken?: string;
    /**
     * <p>The maximum number of results to return for the request in a single page. The remaining results can be seen by sending another request with the returned <code>nextToken</code> value. This value can be between 5 and 500. If <code>maxResults</code> is given a larger value than 500, you receive an error.</p>
     */
    MaxResults?: number;
    /**
     * <p>One or more filters.</p>
     * 		       <ul>
     *             <li>
     * 				           <p>
     *                   <code>state</code> - The state of the Fleet (<code>submitted</code> | <code>modifying</code> | <code>active</code> |
     * 					<code>partially_fulfilled</code> | <code>expiring</code> | <code>expired</code> | <code>cancelling</code> |
     * 					<code>cancelled</code> | <code>failed</code>).</p>
     * 			         </li>
     *             <li>
     * 				           <p>
     *                   <code>instance-match-criteria</code> - The instance matching criteria for the Fleet. Only <code>open</code> is supported.</p>
     * 			         </li>
     *             <li>
     * 				           <p>
     *                   <code>tenancy</code> - The tenancy of the Fleet (<code>default</code> | <code>dedicated</code>).</p>
     * 			         </li>
     *             <li>
     * 				           <p>
     *                   <code>allocation-strategy</code> - The allocation strategy used by the Fleet. Only <code>prioritized</code> is supported.</p>
     * 			         </li>
     *          </ul>
     */
    Filters?: Filter[];
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
}
export declare namespace DescribeCapacityReservationFleetsRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DescribeCapacityReservationFleetsRequest) => any;
}
/**
 * <p>Information about a Capacity Reservation Fleet.</p>
 */
export interface CapacityReservationFleet {
    /**
     * <p>The ID of the Capacity Reservation Fleet.</p>
     */
    CapacityReservationFleetId?: string;
    /**
     * <p>The ARN of the Capacity Reservation Fleet.</p>
     */
    CapacityReservationFleetArn?: string;
    /**
     * <p>The state of the Capacity Reservation Fleet. Possible states include:</p>
     * 		       <ul>
     *             <li>
     * 				           <p>
     *                   <code>submitted</code> - The Capacity Reservation Fleet request has been submitted
     * 					and Amazon Elastic Compute Cloud is preparing to create the Capacity Reservations.</p>
     * 			         </li>
     *             <li>
     * 				           <p>
     *                   <code>modifying</code> - The Capacity Reservation Fleet is being modified. The Fleet
     * 					remains in this state until the modification is complete.</p>
     * 			         </li>
     *             <li>
     * 				           <p>
     *                   <code>active</code> - The Capacity Reservation Fleet has fulfilled its total target
     * 					capacity and it is attempting to maintain this capacity. The Fleet remains in this
     * 					state until it is modified or deleted.</p>
     * 			         </li>
     *             <li>
     * 				           <p>
     *                   <code>partially_fulfilled</code> - The Capacity Reservation Fleet has partially
     * 					fulfilled its total target capacity. There is insufficient Amazon EC2 to
     * 					fulfill the total target capacity. The Fleet is attempting to asynchronously fulfill
     * 					its total target capacity.</p>
     * 			         </li>
     *             <li>
     * 				           <p>
     *                   <code>expiring</code> - The Capacity Reservation Fleet has reach its end date and it
     * 					is in the process of expiring. One or more of its Capacity reservations might still
     * 					be active.</p>
     * 			         </li>
     *             <li>
     * 				           <p>
     *                   <code>expired</code> - The Capacity Reservation Fleet has reach its end date. The Fleet
     * 					and its Capacity Reservations are expired. The Fleet can't create new Capacity
     * 					Reservations.</p>
     * 			         </li>
     *             <li>
     * 				           <p>
     *                   <code>cancelling</code> - The Capacity Reservation Fleet is in the process of being
     * 					cancelled. One or more of its Capacity reservations might still be active.</p>
     * 			         </li>
     *             <li>
     * 				           <p>
     *                   <code>cancelled</code> - The Capacity Reservation Fleet has been manually cancelled.
     * 					The Fleet and its Capacity Reservations are cancelled and the Fleet can't create new
     * 					Capacity Reservations.</p>
     * 			         </li>
     *             <li>
     * 				           <p>
     *                   <code>failed</code> - The Capacity Reservation Fleet failed to reserve capacity for
     * 					the specified instance types.</p>
     * 			         </li>
     *          </ul>
     */
    State?: CapacityReservationFleetState | string;
    /**
     * <p>The total number of capacity units for which the Capacity Reservation Fleet reserves capacity.
     * 			For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/crfleet-concepts.html#target-capacity">Total target capacity</a>
     * 			in the Amazon EC2 User Guide.</p>
     */
    TotalTargetCapacity?: number;
    /**
     * <p>The capacity units that have been fulfilled.</p>
     */
    TotalFulfilledCapacity?: number;
    /**
     * <p>The tenancy of the Capacity Reservation Fleet. Tenancies include:</p>
     * 		       <ul>
     *             <li>
     * 				           <p>
     *                   <code>default</code> - The Capacity Reservation Fleet is created on hardware that is
     * 					shared with other Amazon Web Services accounts.</p>
     * 			         </li>
     *             <li>
     * 				           <p>
     *                   <code>dedicated</code> - The Capacity Reservation Fleet is created on single-tenant
     * 					hardware that is dedicated to a single Amazon Web Services account.</p>
     * 			         </li>
     *          </ul>
     */
    Tenancy?: FleetCapacityReservationTenancy | string;
    /**
     * <p>The date and time at which the Capacity Reservation Fleet expires.</p>
     */
    EndDate?: Date;
    /**
     * <p>The date and time at which the Capacity Reservation Fleet was created.</p>
     */
    CreateTime?: Date;
    /**
     * <p>Indicates the type of instance launches that the Capacity Reservation Fleet accepts. All
     * 			Capacity Reservations in the Fleet inherit this instance matching criteria.</p>
     * 		       <p>Currently, Capacity Reservation Fleets support <code>open</code> instance matching criteria
     * 			only. This means that instances that have matching attributes (instance type, platform, and
     * 			Availability Zone) run in the Capacity Reservations automatically. Instances do not need to
     * 			explicitly target a Capacity Reservation Fleet to use its reserved capacity.</p>
     */
    InstanceMatchCriteria?: FleetInstanceMatchCriteria | string;
    /**
     * <p>The strategy used by the Capacity Reservation Fleet to determine which of the specified
     * 			instance types to use. For more information, see For more information, see
     * 			<a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/crfleet-concepts.html#allocation-strategy">
     * 				Allocation strategy</a> in the Amazon EC2 User Guide.</p>
     */
    AllocationStrategy?: string;
    /**
     * <p>Information about the instance types for which to reserve the capacity.</p>
     */
    InstanceTypeSpecifications?: FleetCapacityReservation[];
    /**
     * <p>The tags assigned to the Capacity Reservation Fleet.</p>
     */
    Tags?: Tag[];
}
export declare namespace CapacityReservationFleet {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: CapacityReservationFleet) => any;
}
export interface DescribeCapacityReservationFleetsResult {
    /**
     * <p>Information about the Capacity Reservation Fleets.</p>
     */
    CapacityReservationFleets?: CapacityReservationFleet[];
    /**
     * <p>The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
     */
    NextToken?: string;
}
export declare namespace DescribeCapacityReservationFleetsResult {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DescribeCapacityReservationFleetsResult) => any;
}
export interface DescribeCapacityReservationsRequest {
    /**
     * <p>The ID of the Capacity Reservation.</p>
     */
    CapacityReservationIds?: string[];
    /**
     * <p>The token to use to retrieve the next page of results.</p>
     */
    NextToken?: string;
    /**
     * <p>The maximum number of results to return for the request in a single page. The remaining results can be seen by sending another request with the returned <code>nextToken</code> value. This value can be between 5 and 500. If <code>maxResults</code> is given a larger value than 500, you receive an error.</p>
     */
    MaxResults?: number;
    /**
     * <p>One or more filters.</p>
     * 	  	     <ul>
     *             <li>
     *                <p>
     *                   <code>instance-type</code> - The type of instance for which the Capacity Reservation reserves capacity.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>owner-id</code> - The ID of the Amazon Web Services account that owns the Capacity Reservation.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>availability-zone-id</code> - The Availability Zone ID of the Capacity Reservation.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>instance-platform</code> - The type of operating system for which the Capacity Reservation reserves capacity.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>availability-zone</code> - The Availability Zone ID of the Capacity Reservation.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>tenancy</code> - Indicates the tenancy of the Capacity Reservation. A Capacity Reservation can have one of the
     * 	  			following tenancy settings:</p>
     * 	  			         <ul>
     *                   <li>
     *                      <p>
     *                         <code>default</code> - The Capacity Reservation is created on hardware that is shared with other Amazon Web Services accounts.</p>
     *                   </li>
     *                   <li>
     *                      <p>
     *                         <code>dedicated</code> - The Capacity Reservation is created on single-tenant hardware that is dedicated to a single Amazon Web Services account.</p>
     *                   </li>
     *                </ul>
     * 	  			      </li>
     *             <li>
     *                <p>
     *                   <code>outpost-arn</code> - The Amazon Resource Name (ARN) of the Outpost on which the Capacity Reservation was created.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>state</code> - The current state of the Capacity Reservation. A Capacity Reservation can be in one of the following states:</p>
     * 	  		          <ul>
     *                   <li>
     *                      <p>
     *                         <code>active</code>- The Capacity Reservation is active and the capacity is available for your use.</p>
     *                   </li>
     *                   <li>
     *                      <p>
     *                         <code>expired</code> - The Capacity Reservation expired automatically at the date and time specified in your request.
     * 	  				The reserved capacity is no longer available for your use.</p>
     *                   </li>
     *                   <li>
     *                      <p>
     *                         <code>cancelled</code> - The Capacity Reservation was cancelled. The reserved capacity is no longer available for your use.</p>
     *                   </li>
     *                   <li>
     *                      <p>
     *                         <code>pending</code> - The Capacity Reservation request was successful but the capacity provisioning is still pending.</p>
     *                   </li>
     *                   <li>
     *                      <p>
     *                         <code>failed</code> - The Capacity Reservation request has failed. A request might fail due to invalid request parameters,
     * 	  				capacity constraints, or instance limit constraints. Failed requests are retained for 60 minutes.</p>
     * 	  		             </li>
     *                </ul>
     * 	  		       </li>
     *             <li>
     *                <p>
     *                   <code>start-date</code> - The date and time at which the Capacity Reservation was started.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>end-date</code> - The date and time at which the Capacity Reservation expires. When a Capacity Reservation expires, the reserved capacity is
     * 	  			released and you can no longer launch instances into it. The Capacity Reservation's state changes to expired when it reaches its end date and time.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>end-date-type</code> - Indicates the way in which the Capacity Reservation ends. A Capacity Reservation can have one of the following end types:</p>
     * 	  		          <ul>
     *                   <li>
     *                      <p>
     *                         <code>unlimited</code> - The Capacity Reservation remains active until you explicitly cancel it.</p>
     *                   </li>
     *                   <li>
     *                      <p>
     *                         <code>limited</code> - The Capacity Reservation expires automatically at a specified date and time.</p>
     *                   </li>
     *                </ul>
     * 	  		       </li>
     *             <li>
     *                <p>
     *                   <code>instance-match-criteria</code> - Indicates the type of instance launches that the Capacity Reservation accepts. The options include:</p>
     * 	  			         <ul>
     *                   <li>
     *                      <p>
     *                         <code>open</code> - The Capacity Reservation accepts all instances that have matching
     * 							attributes (instance type, platform, and Availability Zone). Instances
     * 							that have matching attributes launch into the Capacity Reservation
     * 							automatically without specifying any additional parameters.</p>
     *                   </li>
     *                   <li>
     *                      <p>
     *                         <code>targeted</code> - The Capacity Reservation only accepts instances that have matching
     * 							attributes (instance type, platform, and Availability Zone), and
     * 							explicitly target the Capacity Reservation. This ensures that only
     * 							permitted instances can use the reserved capacity.</p>
     *                   </li>
     *                </ul>
     * 	  		       </li>
     *          </ul>
     */
    Filters?: Filter[];
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
}
export declare namespace DescribeCapacityReservationsRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DescribeCapacityReservationsRequest) => any;
}
export interface DescribeCapacityReservationsResult {
    /**
     * <p>The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
     */
    NextToken?: string;
    /**
     * <p>Information about the Capacity Reservations.</p>
     */
    CapacityReservations?: CapacityReservation[];
}
export declare namespace DescribeCapacityReservationsResult {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DescribeCapacityReservationsResult) => any;
}
export interface DescribeCarrierGatewaysRequest {
    /**
     * <p>One or more carrier gateway IDs.</p>
     */
    CarrierGatewayIds?: string[];
    /**
     * <p>One or more filters.</p>
     *         <ul>
     *             <li>
     *                 <p>
     *                   <code>carrier-gateway-id</code> - The ID of the carrier gateway.</p>
     *             </li>
     *             <li>
     *                 <p>
     *                   <code>state</code> - The state of the carrier gateway (<code>pending</code> |
     *                     <code>failed</code> | <code>available</code> | <code>deleting</code> | <code>deleted</code>).</p>
     *             </li>
     *             <li>
     *                 <p>
     *                   <code>owner-id</code> - The Amazon Web Services account ID of the owner of the carrier gateway.</p>
     *             </li>
     *             <li>
     *                 <p>
     *                   <code>tag</code>:<key> - The key/value combination of a tag assigned to the resource. Use the tag key in the filter name and the tag value as the filter value.
     *     For example, to find all resources that have a tag with the key <code>Owner</code> and the value <code>TeamA</code>, specify <code>tag:Owner</code> for the filter name and <code>TeamA</code> for the filter value.</p>
     *             </li>
     *             <li>
     *                 <p>
     *                   <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all resources assigned a tag with a specific key, regardless of the tag value.</p>
     *             </li>
     *             <li>
     *                 <p>
     *                   <code>vpc-id</code> - The ID of the VPC associated with the carrier gateway.</p>
     *             </li>
     *          </ul>
     */
    Filters?: Filter[];
    /**
     * <p>The maximum number of results to return with a single call.
     * 	To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
     */
    MaxResults?: number;
    /**
     * <p>The token for the next page of results.</p>
     */
    NextToken?: string;
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
}
export declare namespace DescribeCarrierGatewaysRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DescribeCarrierGatewaysRequest) => any;
}
export interface DescribeCarrierGatewaysResult {
    /**
     * <p>Information about the carrier gateway.</p>
     */
    CarrierGateways?: CarrierGateway[];
    /**
     * <p>The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
     */
    NextToken?: string;
}
export declare namespace DescribeCarrierGatewaysResult {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DescribeCarrierGatewaysResult) => any;
}
export interface DescribeClassicLinkInstancesRequest {
    /**
     * <p>One or more filters.</p>
     * 		       <ul>
     *             <li>
     *                       <p>
     *                   <code>group-id</code> - The ID of a VPC security group that's associated with the instance.</p>
     *                   </li>
     *             <li>
     * 				           <p>
     *                   <code>instance-id</code> - The ID of the instance.</p>
     * 			         </li>
     *             <li>
     * 			            <p>
     *                   <code>tag</code>:<key> - The key/value combination of a tag assigned to the resource. Use the tag key in the filter name and the tag value as the filter value.
     *     For example, to find all resources that have a tag with the key <code>Owner</code> and the value <code>TeamA</code>, specify <code>tag:Owner</code> for the filter name and <code>TeamA</code> for the filter value.</p>
     * 			         </li>
     *             <li>
     * 				           <p>
     *                   <code>tag-key</code> - The key of a tag assigned to the resource. Use this filter to find all resources assigned a tag with a specific key, regardless of the tag value.</p>
     * 			         </li>
     *             <li>
     *
     * 				           <p>
     * 					             <code>vpc-id</code> - The ID of the VPC to which the instance is
     * 					linked.</p>
     *
     * 				           <p>
     *                   <code>vpc-id</code> - The ID of the VPC that the instance is linked to.</p>
     *
     * 			         </li>
     *          </ul>
     */
    Filters?: Filter[];
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
    /**
     * <p>One or more instance IDs. Must be instances linked to a VPC through ClassicLink.</p>
     */
    InstanceIds?: string[];
    /**
     * <p>The maximum number of results to return with a single call.
     * 	To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
     * 		       <p>Constraint: If the value is greater than 1000, we return only 1000 items.</p>
     */
    MaxResults?: number;
    /**
     * <p>The token for the next page of results.</p>
     */
    NextToken?: string;
}
export declare namespace DescribeClassicLinkInstancesRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DescribeClassicLinkInstancesRequest) => any;
}
/**
 * <p>Describes a linked EC2-Classic instance.</p>
 */
export interface ClassicLinkInstance {
    /**
     * <p>A list of security groups.</p>
     */
    Groups?: GroupIdentifier[];
    /**
     * <p>The ID of the instance.</p>
     */
    InstanceId?: string;
    /**
     * <p>Any tags assigned to the instance.</p>
     */
    Tags?: Tag[];
    /**
     * <p>The ID of the VPC.</p>
     */
    VpcId?: string;
}
export declare namespace ClassicLinkInstance {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: ClassicLinkInstance) => any;
}
export interface DescribeClassicLinkInstancesResult {
    /**
     * <p>Information about one or more linked EC2-Classic instances.</p>
     */
    Instances?: ClassicLinkInstance[];
    /**
     * <p>The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
     */
    NextToken?: string;
}
export declare namespace DescribeClassicLinkInstancesResult {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DescribeClassicLinkInstancesResult) => any;
}
export interface DescribeClientVpnAuthorizationRulesRequest {
    /**
     * <p>The ID of the Client VPN endpoint.</p>
     */
    ClientVpnEndpointId: string | undefined;
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
    /**
     * <p>The token to retrieve the next page of results.</p>
     */
    NextToken?: string;
    /**
     * <p>One or more filters. Filter names and values are case-sensitive.</p>
     * 	        <ul>
     *             <li>
     *                <p>
     *                   <code>description</code> - The description of the authorization rule.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>destination-cidr</code> - The CIDR of the network to which the authorization rule
     *                     applies.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>group-id</code> - The ID of the Active Directory group to which the authorization rule grants access.</p>
     *             </li>
     *          </ul>
     */
    Filters?: Filter[];
    /**
     * <p>The maximum number of results to return for the request in a single page. The remaining results can be seen by sending another request with the nextToken value.</p>
     */
    MaxResults?: number;
}
export declare namespace DescribeClientVpnAuthorizationRulesRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DescribeClientVpnAuthorizationRulesRequest) => any;
}
/**
 * <p>Information about an authorization rule.</p>
 */
export interface AuthorizationRule {
    /**
     * <p>The ID of the Client VPN endpoint with which the authorization rule is associated.</p>
     */
    ClientVpnEndpointId?: string;
    /**
     * <p>A brief description of the authorization rule.</p>
     */
    Description?: string;
    /**
     * <p>The ID of the Active Directory group to which the authorization rule grants access.</p>
     */
    GroupId?: string;
    /**
     * <p>Indicates whether the authorization rule grants access to all clients.</p>
     */
    AccessAll?: boolean;
    /**
     * <p>The IPv4 address range, in CIDR notation, of the network to which the authorization rule applies.</p>
     */
    DestinationCidr?: string;
    /**
     * <p>The current state of the authorization rule.</p>
     */
    Status?: ClientVpnAuthorizationRuleStatus;
}
export declare namespace AuthorizationRule {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: AuthorizationRule) => any;
}
export interface DescribeClientVpnAuthorizationRulesResult {
    /**
     * <p>Information about the authorization rules.</p>
     */
    AuthorizationRules?: AuthorizationRule[];
    /**
     * <p>The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
     */
    NextToken?: string;
}
export declare namespace DescribeClientVpnAuthorizationRulesResult {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DescribeClientVpnAuthorizationRulesResult) => any;
}
export interface DescribeClientVpnConnectionsRequest {
    /**
     * <p>The ID of the Client VPN endpoint.</p>
     */
    ClientVpnEndpointId: string | undefined;
    /**
     * <p>One or more filters. Filter names and values are case-sensitive.</p>
     * 	        <ul>
     *             <li>
     *                <p>
     *                   <code>connection-id</code> - The ID of the connection.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>username</code> - For Active Directory client authentication, the user name of the
     *                     client who established the client connection.</p>
     *             </li>
     *          </ul>
     */
    Filters?: Filter[];
    /**
     * <p>The token to retrieve the next page of results.</p>
     */
    NextToken?: string;
    /**
     * <p>The maximum number of results to return for the request in a single page. The remaining results can be seen by sending another request with the nextToken value.</p>
     */
    MaxResults?: number;
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
}
export declare namespace DescribeClientVpnConnectionsRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DescribeClientVpnConnectionsRequest) => any;
}
export declare type ClientVpnConnectionStatusCode = "active" | "failed-to-terminate" | "terminated" | "terminating";
/**
 * <p>Describes the status of a client connection.</p>
 */
export interface ClientVpnConnectionStatus {
    /**
     * <p>The state of the client connection.</p>
     */
    Code?: ClientVpnConnectionStatusCode | string;
    /**
     * <p>A message about the status of the client connection, if applicable.</p>
     */
    Message?: string;
}
export declare namespace ClientVpnConnectionStatus {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: ClientVpnConnectionStatus) => any;
}
/**
 * <p>Describes a client connection.</p>
 */
export interface ClientVpnConnection {
    /**
     * <p>The ID of the Client VPN endpoint to which the client is connected.</p>
     */
    ClientVpnEndpointId?: string;
    /**
     * <p>The current date and time.</p>
     */
    Timestamp?: string;
    /**
     * <p>The ID of the client connection.</p>
     */
    ConnectionId?: string;
    /**
     * <p>The username of the client who established the client connection. This information is only provided
     * 			if Active Directory client authentication is used.</p>
     */
    Username?: string;
    /**
     * <p>The date and time the client connection was established.</p>
     */
    ConnectionEstablishedTime?: string;
    /**
     * <p>The number of bytes sent by the client.</p>
     */
    IngressBytes?: string;
    /**
     * <p>The number of bytes received by the client.</p>
     */
    EgressBytes?: string;
    /**
     * <p>The number of packets sent by the client.</p>
     */
    IngressPackets?: string;
    /**
     * <p>The number of packets received by the client.</p>
     */
    EgressPackets?: string;
    /**
     * <p>The IP address of the client.</p>
     */
    ClientIp?: string;
    /**
     * <p>The common name associated with the client. This is either the name of the client certificate,
     * 			or the Active Directory user name.</p>
     */
    CommonName?: string;
    /**
     * <p>The current state of the client connection.</p>
     */
    Status?: ClientVpnConnectionStatus;
    /**
     * <p>The date and time the client connection was terminated.</p>
     */
    ConnectionEndTime?: string;
    /**
     * <p>The statuses returned by the client connect handler for posture compliance, if applicable.</p>
     */
    PostureComplianceStatuses?: string[];
}
export declare namespace ClientVpnConnection {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: ClientVpnConnection) => any;
}
export interface DescribeClientVpnConnectionsResult {
    /**
     * <p>Information about the active and terminated client connections.</p>
     */
    Connections?: ClientVpnConnection[];
    /**
     * <p>The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
     */
    NextToken?: string;
}
export declare namespace DescribeClientVpnConnectionsResult {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DescribeClientVpnConnectionsResult) => any;
}
export interface DescribeClientVpnEndpointsRequest {
    /**
     * <p>The ID of the Client VPN endpoint.</p>
     */
    ClientVpnEndpointIds?: string[];
    /**
     * <p>The maximum number of results to return for the request in a single page. The remaining results can be seen by sending another request with the nextToken value.</p>
     */
    MaxResults?: number;
    /**
     * <p>The token to retrieve the next page of results.</p>
     */
    NextToken?: string;
    /**
     * <p>One or more filters. Filter names and values are case-sensitive.</p>
     * 	        <ul>
     *             <li>
     *                <p>
     *                   <code>endpoint-id</code> - The ID of the Client VPN endpoint.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>transport-protocol</code> - The transport protocol (<code>tcp</code> |
     *                     <code>udp</code>).</p>
     *             </li>
     *          </ul>
     */
    Filters?: Filter[];
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
}
export declare namespace DescribeClientVpnEndpointsRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DescribeClientVpnEndpointsRequest) => any;
}
export declare type AssociatedNetworkType = "vpc";
/**
 * <p>Describes a target network that is associated with a Client VPN endpoint. A target network is a subnet in a VPC.</p>
 */
export interface AssociatedTargetNetwork {
    /**
     * <p>The ID of the subnet.</p>
     */
    NetworkId?: string;
    /**
     * <p>The target network type.</p>
     */
    NetworkType?: AssociatedNetworkType | string;
}
export declare namespace AssociatedTargetNetwork {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: AssociatedTargetNetwork) => any;
}
/**
 * <p>Describes an Active Directory.</p>
 */
export interface DirectoryServiceAuthentication {
    /**
     * <p>The ID of the Active Directory used for authentication.</p>
     */
    DirectoryId?: string;
}
export declare namespace DirectoryServiceAuthentication {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DirectoryServiceAuthentication) => any;
}
/**
 * <p>Describes the IAM SAML identity providers used for federated authentication.</p>
 */
export interface FederatedAuthentication {
    /**
     * <p>The Amazon Resource Name (ARN) of the IAM SAML identity provider.</p>
     */
    SamlProviderArn?: string;
    /**
     * <p>The Amazon Resource Name (ARN) of the IAM SAML identity provider for the self-service portal.</p>
     */
    SelfServiceSamlProviderArn?: string;
}
export declare namespace FederatedAuthentication {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: FederatedAuthentication) => any;
}
/**
 * <p>Information about the client certificate used for authentication.</p>
 */
export interface CertificateAuthentication {
    /**
     * <p>The ARN of the client certificate. </p>
     */
    ClientRootCertificateChain?: string;
}
export declare namespace CertificateAuthentication {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: CertificateAuthentication) => any;
}
/**
 * <p>Describes the authentication methods used by a Client VPN endpoint. For more information, see <a href="https://docs.aws.amazon.com/vpn/latest/clientvpn-admin/client-authentication.html">Authentication</a>
 * 			in the <i>Client VPN Administrator Guide</i>.</p>
 */
export interface ClientVpnAuthentication {
    /**
     * <p>The authentication type used.</p>
     */
    Type?: ClientVpnAuthenticationType | string;
    /**
     * <p>Information about the Active Directory, if applicable.</p>
     */
    ActiveDirectory?: DirectoryServiceAuthentication;
    /**
     * <p>Information about the authentication certificates, if applicable.</p>
     */
    MutualAuthentication?: CertificateAuthentication;
    /**
     * <p>Information about the IAM SAML identity provider, if applicable.</p>
     */
    FederatedAuthentication?: FederatedAuthentication;
}
export declare namespace ClientVpnAuthentication {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: ClientVpnAuthentication) => any;
}
export declare type ClientVpnEndpointAttributeStatusCode = "applied" | "applying";
/**
 * <p>Describes the status of the Client VPN endpoint attribute.</p>
 */
export interface ClientVpnEndpointAttributeStatus {
    /**
     * <p>The status code.</p>
     */
    Code?: ClientVpnEndpointAttributeStatusCode | string;
    /**
     * <p>The status message.</p>
     */
    Message?: string;
}
export declare namespace ClientVpnEndpointAttributeStatus {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: ClientVpnEndpointAttributeStatus) => any;
}
/**
 * <p>The options for managing connection authorization for new client connections.</p>
 */
export interface ClientConnectResponseOptions {
    /**
     * <p>Indicates whether client connect options are enabled.</p>
     */
    Enabled?: boolean;
    /**
     * <p>The Amazon Resource Name (ARN) of the Lambda function used for connection authorization.</p>
     */
    LambdaFunctionArn?: string;
    /**
     * <p>The status of any updates to the client connect options.</p>
     */
    Status?: ClientVpnEndpointAttributeStatus;
}
export declare namespace ClientConnectResponseOptions {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: ClientConnectResponseOptions) => any;
}
/**
 * <p>Information about the client connection logging options for a Client VPN endpoint.</p>
 */
export interface ConnectionLogResponseOptions {
    /**
     * <p>Indicates whether client connection logging is enabled for the Client VPN endpoint.</p>
     */
    Enabled?: boolean;
    /**
     * <p>The name of the Amazon CloudWatch Logs log group to which connection logging data is published.</p>
     */
    CloudwatchLogGroup?: string;
    /**
     * <p>The name of the Amazon CloudWatch Logs log stream to which connection logging data is published.</p>
     */
    CloudwatchLogStream?: string;
}
export declare namespace ConnectionLogResponseOptions {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: ConnectionLogResponseOptions) => any;
}
export declare type VpnProtocol = "openvpn";
/**
 * <p>Describes a Client VPN endpoint.</p>
 */
export interface ClientVpnEndpoint {
    /**
     * <p>The ID of the Client VPN endpoint.</p>
     */
    ClientVpnEndpointId?: string;
    /**
     * <p>A brief description of the endpoint.</p>
     */
    Description?: string;
    /**
     * <p>The current state of the Client VPN endpoint.</p>
     */
    Status?: ClientVpnEndpointStatus;
    /**
     * <p>The date and time the Client VPN endpoint was created.</p>
     */
    CreationTime?: string;
    /**
     * <p>The date and time the Client VPN endpoint was deleted, if applicable.</p>
     */
    DeletionTime?: string;
    /**
     * <p>The DNS name to be used by clients when connecting to the Client VPN endpoint.</p>
     */
    DnsName?: string;
    /**
     * <p>The IPv4 address range, in CIDR notation, from which client IP addresses are assigned.</p>
     */
    ClientCidrBlock?: string;
    /**
     * <p>Information about the DNS servers to be used for DNS resolution. </p>
     */
    DnsServers?: string[];
    /**
     * <p>Indicates whether split-tunnel is enabled in the Client VPN endpoint.</p>
     * 		       <p>For information about split-tunnel VPN endpoints, see <a href="https://docs.aws.amazon.com/vpn/latest/clientvpn-admin/split-tunnel-vpn.html">Split-Tunnel Client VPN endpoint</a>
     * 			in the <i>Client VPN Administrator Guide</i>.</p>
     */
    SplitTunnel?: boolean;
    /**
     * <p>The protocol used by the VPN session.</p>
     */
    VpnProtocol?: VpnProtocol | string;
    /**
     * <p>The transport protocol used by the Client VPN endpoint.</p>
     */
    TransportProtocol?: TransportProtocol | string;
    /**
     * <p>The port number for the  Client VPN endpoint.</p>
     */
    VpnPort?: number;
    /**
     * @deprecated
     *
     * <p>Information about the associated target networks. A target network is a subnet in a VPC.</p>
     */
    AssociatedTargetNetworks?: AssociatedTargetNetwork[];
    /**
     * <p>The ARN of the server certificate.</p>
     */
    ServerCertificateArn?: string;
    /**
     * <p>Information about the authentication method used by the Client VPN endpoint.</p>
     */
    AuthenticationOptions?: ClientVpnAuthentication[];
    /**
     * <p>Information about the client connection logging options for the Client VPN endpoint.</p>
     */
    ConnectionLogOptions?: ConnectionLogResponseOptions;
    /**
     * <p>Any tags assigned to the Client VPN endpoint.</p>
     */
    Tags?: Tag[];
    /**
     * <p>The IDs of the security groups for the target network.</p>
     */
    SecurityGroupIds?: string[];
    /**
     * <p>The ID of the VPC.</p>
     */
    VpcId?: string;
    /**
     * <p>The URL of the self-service portal.</p>
     */
    SelfServicePortalUrl?: string;
    /**
     * <p>The options for managing connection authorization for new client connections.</p>
     */
    ClientConnectOptions?: ClientConnectResponseOptions;
}
export declare namespace ClientVpnEndpoint {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: ClientVpnEndpoint) => any;
}
export interface DescribeClientVpnEndpointsResult {
    /**
     * <p>Information about the Client VPN endpoints.</p>
     */
    ClientVpnEndpoints?: ClientVpnEndpoint[];
    /**
     * <p>The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
     */
    NextToken?: string;
}
export declare namespace DescribeClientVpnEndpointsResult {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DescribeClientVpnEndpointsResult) => any;
}
export interface DescribeClientVpnRoutesRequest {
    /**
     * <p>The ID of the Client VPN endpoint.</p>
     */
    ClientVpnEndpointId: string | undefined;
    /**
     * <p>One or more filters. Filter names and values are case-sensitive.</p>
     * 	        <ul>
     *             <li>
     *                <p>
     *                   <code>destination-cidr</code> - The CIDR of the route destination.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>origin</code> - How the route was associated with the Client VPN endpoint (<code>associate</code> | <code>add-route</code>).</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>target-subnet</code> - The ID of the subnet through which traffic is routed.</p>
     *             </li>
     *          </ul>
     */
    Filters?: Filter[];
    /**
     * <p>The maximum number of results to return for the request in a single page. The remaining results can be seen by sending another request with the nextToken value.</p>
     */
    MaxResults?: number;
    /**
     * <p>The token to retrieve the next page of results.</p>
     */
    NextToken?: string;
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
}
export declare namespace DescribeClientVpnRoutesRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DescribeClientVpnRoutesRequest) => any;
}
/**
 * <p>Information about a Client VPN endpoint route.</p>
 */
export interface ClientVpnRoute {
    /**
     * <p>The ID of the Client VPN endpoint with which the route is associated.</p>
     */
    ClientVpnEndpointId?: string;
    /**
     * <p>The IPv4 address range, in CIDR notation, of the route destination.</p>
     */
    DestinationCidr?: string;
    /**
     * <p>The ID of the subnet through which traffic is routed.</p>
     */
    TargetSubnet?: string;
    /**
     * <p>The route type.</p>
     */
    Type?: string;
    /**
     * <p>Indicates how the route was associated with the Client VPN endpoint.
     * 			<code>associate</code> indicates that the route was automatically added when the target network
     * 			was associated with the Client VPN endpoint. <code>add-route</code> indicates that the route
     * 			was manually added using the <b>CreateClientVpnRoute</b> action.</p>
     */
    Origin?: string;
    /**
     * <p>The current state of the route.</p>
     */
    Status?: ClientVpnRouteStatus;
    /**
     * <p>A brief description of the route.</p>
     */
    Description?: string;
}
export declare namespace ClientVpnRoute {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: ClientVpnRoute) => any;
}
export interface DescribeClientVpnRoutesResult {
    /**
     * <p>Information about the Client VPN endpoint routes.</p>
     */
    Routes?: ClientVpnRoute[];
    /**
     * <p>The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
     */
    NextToken?: string;
}
export declare namespace DescribeClientVpnRoutesResult {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DescribeClientVpnRoutesResult) => any;
}
export interface DescribeClientVpnTargetNetworksRequest {
    /**
     * <p>The ID of the Client VPN endpoint.</p>
     */
    ClientVpnEndpointId: string | undefined;
    /**
     * <p>The IDs of the target network associations.</p>
     */
    AssociationIds?: string[];
    /**
     * <p>The maximum number of results to return for the request in a single page. The remaining results can be seen by sending another request with the nextToken value.</p>
     */
    MaxResults?: number;
    /**
     * <p>The token to retrieve the next page of results.</p>
     */
    NextToken?: string;
    /**
     * <p>One or more filters. Filter names and values are case-sensitive.</p>
     * 	        <ul>
     *             <li>
     *                <p>
     *                   <code>association-id</code> - The ID of the association.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>target-network-id</code> - The ID of the subnet specified as the target network.</p>
     *             </li>
     *             <li>
     *                <p>
     *                   <code>vpc-id</code> - The ID of the VPC in which the target network is located.</p>
     *             </li>
     *          </ul>
     */
    Filters?: Filter[];
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
}
export declare namespace DescribeClientVpnTargetNetworksRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DescribeClientVpnTargetNetworksRequest) => any;
}
/**
 * <p>Describes a target network associated with a Client VPN endpoint.</p>
 */
export interface TargetNetwork {
    /**
     * <p>The ID of the association.</p>
     */
    AssociationId?: string;
    /**
     * <p>The ID of the VPC in which the target network (subnet) is located.</p>
     */
    VpcId?: string;
    /**
     * <p>The ID of the subnet specified as the target network.</p>
     */
    TargetNetworkId?: string;
    /**
     * <p>The ID of the Client VPN endpoint with which the target network is associated.</p>
     */
    ClientVpnEndpointId?: string;
    /**
     * <p>The current state of the target network association.</p>
     */
    Status?: AssociationStatus;
    /**
     * <p>The IDs of the security groups applied to the target network association.</p>
     */
    SecurityGroups?: string[];
}
export declare namespace TargetNetwork {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: TargetNetwork) => any;
}
export interface DescribeClientVpnTargetNetworksResult {
    /**
     * <p>Information about the associated target networks.</p>
     */
    ClientVpnTargetNetworks?: TargetNetwork[];
    /**
     * <p>The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
     */
    NextToken?: string;
}
export declare namespace DescribeClientVpnTargetNetworksResult {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DescribeClientVpnTargetNetworksResult) => any;
}
export interface DescribeCoipPoolsRequest {
    /**
     * <p>The IDs of the address pools.</p>
     */
    PoolIds?: string[];
    /**
     * <p>The filters. The following are the possible values:</p>
     *          <ul>
     *             <li>
     *                <p>
     *                   <code>coip-pool.pool-id</code>
     *                </p>
     *             </li>
     *          </ul>
     *          <ul>
     *             <li>
     *                <p>
     *                   <code>coip-pool.local-gateway-route-table-id</code>
     *                </p>
     *             </li>
     *          </ul>
     */
    Filters?: Filter[];
    /**
     * <p>The maximum number of results to return with a single call.
     * 	To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>
     */
    MaxResults?: number;
    /**
     * <p>The token for the next page of results.</p>
     */
    NextToken?: string;
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
}
export declare namespace DescribeCoipPoolsRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DescribeCoipPoolsRequest) => any;
}
/**
 * <p>Describes a customer-owned address pool.</p>
 */
export interface CoipPool {
    /**
     * <p>The ID of the address pool.</p>
     */
    PoolId?: string;
    /**
     * <p>The address ranges of the address pool.</p>
     */
    PoolCidrs?: string[];
    /**
     * <p>The ID of the local gateway route table.</p>
     */
    LocalGatewayRouteTableId?: string;
    /**
     * <p>The tags.</p>
     */
    Tags?: Tag[];
    /**
     * <p>The ARN of the address pool.</p>
     */
    PoolArn?: string;
}
export declare namespace CoipPool {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: CoipPool) => any;
}
export interface DescribeCoipPoolsResult {
    /**
     * <p>Information about the address pools.</p>
     */
    CoipPools?: CoipPool[];
    /**
     * <p>The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>
     */
    NextToken?: string;
}
export declare namespace DescribeCoipPoolsResult {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DescribeCoipPoolsResult) => any;
}
export interface DescribeConversionTasksRequest {
    /**
     * <p>The conversion task IDs.</p>
     */
    ConversionTaskIds?: string[];
    /**
     * <p>Checks whether you have the required permissions for the action, without actually making the request,
     *    and provides an error response. If you have the required permissions, the error response is <code>DryRunOperation</code>.
     *    Otherwise, it is <code>UnauthorizedOperation</code>.</p>
     */
    DryRun?: boolean;
}
export declare namespace DescribeConversionTasksRequest {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DescribeConversionTasksRequest) => any;
}
/**
 * <p>Describes a disk image.</p>
 */
export interface DiskImageDescription {
    /**
     * <p>The checksum computed for the disk image.</p>
     */
    Checksum?: string;
    /**
     * <p>The disk image format.</p>
     */
    Format?: DiskImageFormat | string;
    /**
     * <p>A presigned URL for the import manifest stored in Amazon S3. For information about creating a presigned URL for
     *    an Amazon S3 object, read the "Query String Request Authentication Alternative" section of the <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/RESTAuthentication.html">Authenticating REST Requests</a> topic in
     *    the <i>Amazon Simple Storage Service Developer Guide</i>.</p>
     *          <p>For information about the import manifest referenced by this API action, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/manifest.html">VM Import Manifest</a>.</p>
     */
    ImportManifestUrl?: string;
    /**
     * <p>The size of the disk image, in GiB.</p>
     */
    Size?: number;
}
export declare namespace DiskImageDescription {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DiskImageDescription) => any;
}
/**
 * <p>Describes a disk image volume.</p>
 */
export interface DiskImageVolumeDescription {
    /**
     * <p>The volume identifier.</p>
     */
    Id?: string;
    /**
     * <p>The size of the volume, in GiB.</p>
     */
    Size?: number;
}
export declare namespace DiskImageVolumeDescription {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: DiskImageVolumeDescription) => any;
}
/**
 * <p>Describes an import volume task.</p>
 */
export interface ImportInstanceVolumeDetailItem {
    /**
     * <p>The Availability Zone where the resulting instance will reside.</p>
     */
    AvailabilityZone?: string;
    /**
     * <p>The number of bytes converted so far.</p>
     */
    BytesConverted?: number;
    /**
     * <p>A description of the task.</p>
     */
    Description?: string;
    /**
     * <p>The image.</p>
     */
    Image?: DiskImageDescription;
    /**
     * <p>The status of the import of this particular disk image.</p>
     */
    Status?: string;
    /**
     * <p>The status information or errors related to the disk image.</p>
     */
    StatusMessage?: string;
    /**
     * <p>The volume.</p>
     */
    Volume?: DiskImageVolumeDescription;
}
export declare namespace ImportInstanceVolumeDetailItem {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: ImportInstanceVolumeDetailItem) => any;
}
/**
 * <p>Describes an import instance task.</p>
 */
export interface ImportInstanceTaskDetails {
    /**
     * <p>A description of the task.</p>
     */
    Description?: string;
    /**
     * <p>The ID of the instance.</p>
     */
    InstanceId?: string;
    /**
     * <p>The instance operating system.</p>
     */
    Platform?: PlatformValues | string;
    /**
     * <p>The volumes.</p>
     */
    Volumes?: ImportInstanceVolumeDetailItem[];
}
export declare namespace ImportInstanceTaskDetails {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: ImportInstanceTaskDetails) => any;
}
/**
 * <p>Describes an import volume task.</p>
 */
export interface ImportVolumeTaskDetails {
    /**
     * <p>The Availability Zone where the resulting volume will reside.</p>
     */
    AvailabilityZone?: string;
    /**
     * <p>The number of bytes converted so far.</p>
     */
    BytesConverted?: number;
    /**
     * <p>The description you provided when starting the import volume task.</p>
     */
    Description?: string;
    /**
     * <p>The image.</p>
     */
    Image?: DiskImageDescription;
    /**
     * <p>The volume.</p>
     */
    Volume?: DiskImageVolumeDescription;
}
export declare namespace ImportVolumeTaskDetails {
    /**
     * @internal
     */
    const filterSensitiveLog: (obj: ImportVolumeTaskDetails) => any;
}
export declare type ConversionTaskState = "active" | "cancelled" | "cancelling" | "completed";
