import { Command as $Command } from "@aws-sdk/smithy-client";
import { Handler, HttpHandlerOptions as __HttpHandlerOptions, MetadataBearer as __MetadataBearer, MiddlewareStack } from "@aws-sdk/types";
import { EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../EC2Client";
import { MoveByoipCidrToIpamRequest, MoveByoipCidrToIpamResult } from "../models/models_5";
export interface MoveByoipCidrToIpamCommandInput extends MoveByoipCidrToIpamRequest {
}
export interface MoveByoipCidrToIpamCommandOutput extends MoveByoipCidrToIpamResult, __MetadataBearer {
}
/**
 * <p>Move an BYOIP IPv4 CIDR to IPAM from a public IPv4 pool.</p>
 * @example
 * Use a bare-bones client and the command you need to make an API call.
 * ```javascript
 * import { EC2Client, MoveByoipCidrToIpamCommand } from "@aws-sdk/client-ec2"; // ES Modules import
 * // const { EC2Client, MoveByoipCidrToIpamCommand } = require("@aws-sdk/client-ec2"); // CommonJS import
 * const client = new EC2Client(config);
 * const command = new MoveByoipCidrToIpamCommand(input);
 * const response = await client.send(command);
 * ```
 *
 * @see {@link MoveByoipCidrToIpamCommandInput} for command's `input` shape.
 * @see {@link MoveByoipCidrToIpamCommandOutput} for command's `response` shape.
 * @see {@link EC2ClientResolvedConfig | config} for EC2Client's `config` shape.
 *
 */
export declare class MoveByoipCidrToIpamCommand extends $Command<MoveByoipCidrToIpamCommandInput, MoveByoipCidrToIpamCommandOutput, EC2ClientResolvedConfig> {
    readonly input: MoveByoipCidrToIpamCommandInput;
    constructor(input: MoveByoipCidrToIpamCommandInput);
    /**
     * @internal
     */
    resolveMiddleware(clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>, configuration: EC2ClientResolvedConfig, options?: __HttpHandlerOptions): Handler<MoveByoipCidrToIpamCommandInput, MoveByoipCidrToIpamCommandOutput>;
    private serialize;
    private deserialize;
}
