import { Command as $Command } from "@aws-sdk/smithy-client";
import { Handler, HttpHandlerOptions as __HttpHandlerOptions, MetadataBearer as __MetadataBearer, MiddlewareStack } from "@aws-sdk/types";
import { EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../EC2Client";
import { ModifyCapacityReservationFleetRequest, ModifyCapacityReservationFleetResult } from "../models/models_5";
export interface ModifyCapacityReservationFleetCommandInput extends ModifyCapacityReservationFleetRequest {
}
export interface ModifyCapacityReservationFleetCommandOutput extends ModifyCapacityReservationFleetResult, __MetadataBearer {
}
/**
 * <p>Modifies a Capacity Reservation Fleet.</p>
 * 		       <p>When you modify the total target capacity of a Capacity Reservation Fleet, the Fleet automatically
 * 			creates new Capacity Reservations, or modifies or cancels existing Capacity Reservations in the Fleet
 * 			to meet the new total target capacity. When you modify the end date for the Fleet, the end dates for
 * 			all of the individual Capacity Reservations in the Fleet are updated accordingly.</p>
 * @example
 * Use a bare-bones client and the command you need to make an API call.
 * ```javascript
 * import { EC2Client, ModifyCapacityReservationFleetCommand } from "@aws-sdk/client-ec2"; // ES Modules import
 * // const { EC2Client, ModifyCapacityReservationFleetCommand } = require("@aws-sdk/client-ec2"); // CommonJS import
 * const client = new EC2Client(config);
 * const command = new ModifyCapacityReservationFleetCommand(input);
 * const response = await client.send(command);
 * ```
 *
 * @see {@link ModifyCapacityReservationFleetCommandInput} for command's `input` shape.
 * @see {@link ModifyCapacityReservationFleetCommandOutput} for command's `response` shape.
 * @see {@link EC2ClientResolvedConfig | config} for EC2Client's `config` shape.
 *
 */
export declare class ModifyCapacityReservationFleetCommand extends $Command<ModifyCapacityReservationFleetCommandInput, ModifyCapacityReservationFleetCommandOutput, EC2ClientResolvedConfig> {
    readonly input: ModifyCapacityReservationFleetCommandInput;
    constructor(input: ModifyCapacityReservationFleetCommandInput);
    /**
     * @internal
     */
    resolveMiddleware(clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>, configuration: EC2ClientResolvedConfig, options?: __HttpHandlerOptions): Handler<ModifyCapacityReservationFleetCommandInput, ModifyCapacityReservationFleetCommandOutput>;
    private serialize;
    private deserialize;
}
