import { Command as $Command } from "@aws-sdk/smithy-client";
import { Handler, HttpHandlerOptions as __HttpHandlerOptions, MetadataBearer as __MetadataBearer, MiddlewareStack } from "@aws-sdk/types";
import { EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../EC2Client";
import { GetSpotPlacementScoresRequest, GetSpotPlacementScoresResult } from "../models/models_5";
export interface GetSpotPlacementScoresCommandInput extends GetSpotPlacementScoresRequest {
}
export interface GetSpotPlacementScoresCommandOutput extends GetSpotPlacementScoresResult, __MetadataBearer {
}
/**
 * <p>Calculates the Spot placement score for a Region or Availability Zone based on the
 *          specified target capacity and compute requirements.</p>
 *          <p>You can specify your compute requirements either by using
 *             <code>InstanceRequirementsWithMetadata</code> and letting Amazon EC2 choose the optimal
 *          instance types to fulfill your Spot request, or you can specify the instance types by using
 *             <code>InstanceTypes</code>.</p>
 *          <p>For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/spot-placement-score.html">Spot placement score</a> in
 *          the Amazon EC2 User Guide.</p>
 * @example
 * Use a bare-bones client and the command you need to make an API call.
 * ```javascript
 * import { EC2Client, GetSpotPlacementScoresCommand } from "@aws-sdk/client-ec2"; // ES Modules import
 * // const { EC2Client, GetSpotPlacementScoresCommand } = require("@aws-sdk/client-ec2"); // CommonJS import
 * const client = new EC2Client(config);
 * const command = new GetSpotPlacementScoresCommand(input);
 * const response = await client.send(command);
 * ```
 *
 * @see {@link GetSpotPlacementScoresCommandInput} for command's `input` shape.
 * @see {@link GetSpotPlacementScoresCommandOutput} for command's `response` shape.
 * @see {@link EC2ClientResolvedConfig | config} for EC2Client's `config` shape.
 *
 */
export declare class GetSpotPlacementScoresCommand extends $Command<GetSpotPlacementScoresCommandInput, GetSpotPlacementScoresCommandOutput, EC2ClientResolvedConfig> {
    readonly input: GetSpotPlacementScoresCommandInput;
    constructor(input: GetSpotPlacementScoresCommandInput);
    /**
     * @internal
     */
    resolveMiddleware(clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>, configuration: EC2ClientResolvedConfig, options?: __HttpHandlerOptions): Handler<GetSpotPlacementScoresCommandInput, GetSpotPlacementScoresCommandOutput>;
    private serialize;
    private deserialize;
}
