import { Command as $Command } from "@aws-sdk/smithy-client";
import { Handler, HttpHandlerOptions as __HttpHandlerOptions, MetadataBearer as __MetadataBearer, MiddlewareStack } from "@aws-sdk/types";
import { EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../EC2Client";
import { GetInstanceTypesFromInstanceRequirementsRequest, GetInstanceTypesFromInstanceRequirementsResult } from "../models/models_4";
export interface GetInstanceTypesFromInstanceRequirementsCommandInput extends GetInstanceTypesFromInstanceRequirementsRequest {
}
export interface GetInstanceTypesFromInstanceRequirementsCommandOutput extends GetInstanceTypesFromInstanceRequirementsResult, __MetadataBearer {
}
/**
 * <p>Returns a list of instance types with the specified instance attributes. You can
 *          use the response to preview the instance types without launching instances. Note
 *          that the response does not consider capacity.</p>
 *          <p>When you specify multiple parameters, you get instance types that satisfy all of the
 *          specified parameters. If you specify multiple values for a parameter, you get instance
 *          types that satisfy any of the specified values.</p>
 *          <p>For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/spot-fleet-attribute-based-instance-type-selection.html#spotfleet-get-instance-types-from-instance-requirements">Preview instance types with specified attributes</a>, <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-fleet-attribute-based-instance-type-selection.html">Attribute-based instance type selection for EC2 Fleet</a>, <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/spot-fleet-attribute-based-instance-type-selection.html">Attribute-based instance type selection for Spot Fleet</a>, and <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/spot-placement-score.html">Spot
 *             placement score</a> in the <i>Amazon EC2 User Guide</i>, and <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/create-asg-instance-type-requirements.html">Creating an
 *             Auto Scaling group using attribute-based instance type selection</a> in the
 *             <i>Amazon EC2 Auto Scaling User Guide</i>.</p>
 * @example
 * Use a bare-bones client and the command you need to make an API call.
 * ```javascript
 * import { EC2Client, GetInstanceTypesFromInstanceRequirementsCommand } from "@aws-sdk/client-ec2"; // ES Modules import
 * // const { EC2Client, GetInstanceTypesFromInstanceRequirementsCommand } = require("@aws-sdk/client-ec2"); // CommonJS import
 * const client = new EC2Client(config);
 * const command = new GetInstanceTypesFromInstanceRequirementsCommand(input);
 * const response = await client.send(command);
 * ```
 *
 * @see {@link GetInstanceTypesFromInstanceRequirementsCommandInput} for command's `input` shape.
 * @see {@link GetInstanceTypesFromInstanceRequirementsCommandOutput} for command's `response` shape.
 * @see {@link EC2ClientResolvedConfig | config} for EC2Client's `config` shape.
 *
 */
export declare class GetInstanceTypesFromInstanceRequirementsCommand extends $Command<GetInstanceTypesFromInstanceRequirementsCommandInput, GetInstanceTypesFromInstanceRequirementsCommandOutput, EC2ClientResolvedConfig> {
    readonly input: GetInstanceTypesFromInstanceRequirementsCommandInput;
    constructor(input: GetInstanceTypesFromInstanceRequirementsCommandInput);
    /**
     * @internal
     */
    resolveMiddleware(clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>, configuration: EC2ClientResolvedConfig, options?: __HttpHandlerOptions): Handler<GetInstanceTypesFromInstanceRequirementsCommandInput, GetInstanceTypesFromInstanceRequirementsCommandOutput>;
    private serialize;
    private deserialize;
}
