import { Command as $Command } from "@aws-sdk/smithy-client";
import { Handler, HttpHandlerOptions as __HttpHandlerOptions, MetadataBearer as __MetadataBearer, MiddlewareStack } from "@aws-sdk/types";
import { EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../EC2Client";
import { DeleteVpnGatewayRequest } from "../models/models_2";
export interface DeleteVpnGatewayCommandInput extends DeleteVpnGatewayRequest {
}
export interface DeleteVpnGatewayCommandOutput extends __MetadataBearer {
}
/**
 * <p>Deletes the specified virtual private gateway. You must first detach the virtual
 *             private gateway from the VPC. Note that you don't need to delete the virtual private
 *             gateway if you plan to delete and recreate the VPN connection between your VPC and your
 *             network.</p>
 * @example
 * Use a bare-bones client and the command you need to make an API call.
 * ```javascript
 * import { EC2Client, DeleteVpnGatewayCommand } from "@aws-sdk/client-ec2"; // ES Modules import
 * // const { EC2Client, DeleteVpnGatewayCommand } = require("@aws-sdk/client-ec2"); // CommonJS import
 * const client = new EC2Client(config);
 * const command = new DeleteVpnGatewayCommand(input);
 * const response = await client.send(command);
 * ```
 *
 * @see {@link DeleteVpnGatewayCommandInput} for command's `input` shape.
 * @see {@link DeleteVpnGatewayCommandOutput} for command's `response` shape.
 * @see {@link EC2ClientResolvedConfig | config} for EC2Client's `config` shape.
 *
 */
export declare class DeleteVpnGatewayCommand extends $Command<DeleteVpnGatewayCommandInput, DeleteVpnGatewayCommandOutput, EC2ClientResolvedConfig> {
    readonly input: DeleteVpnGatewayCommandInput;
    constructor(input: DeleteVpnGatewayCommandInput);
    /**
     * @internal
     */
    resolveMiddleware(clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>, configuration: EC2ClientResolvedConfig, options?: __HttpHandlerOptions): Handler<DeleteVpnGatewayCommandInput, DeleteVpnGatewayCommandOutput>;
    private serialize;
    private deserialize;
}
