import { Command as $Command } from "@aws-sdk/smithy-client";
import { Handler, HttpHandlerOptions as __HttpHandlerOptions, MetadataBearer as __MetadataBearer, MiddlewareStack } from "@aws-sdk/types";
import { EC2ClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../EC2Client";
import { CreateNetworkInsightsAccessScopeRequest, CreateNetworkInsightsAccessScopeResult } from "../models/models_1";
export interface CreateNetworkInsightsAccessScopeCommandInput extends CreateNetworkInsightsAccessScopeRequest {
}
export interface CreateNetworkInsightsAccessScopeCommandOutput extends CreateNetworkInsightsAccessScopeResult, __MetadataBearer {
}
/**
 * <p>Creates a Network Access Scope.</p>
 *          <p>Amazon Web Services Network Access Analyzer enables cloud networking and cloud operations teams
 *          to verify that their networks on Amazon Web Services conform to their network security and governance
 *          objectives. For more information, see the <a href="https://docs.aws.amazon.com/vpc/latest/network-access-analyzer/">Amazon Web Services Network Access Analyzer Guide</a>.</p>
 * @example
 * Use a bare-bones client and the command you need to make an API call.
 * ```javascript
 * import { EC2Client, CreateNetworkInsightsAccessScopeCommand } from "@aws-sdk/client-ec2"; // ES Modules import
 * // const { EC2Client, CreateNetworkInsightsAccessScopeCommand } = require("@aws-sdk/client-ec2"); // CommonJS import
 * const client = new EC2Client(config);
 * const command = new CreateNetworkInsightsAccessScopeCommand(input);
 * const response = await client.send(command);
 * ```
 *
 * @see {@link CreateNetworkInsightsAccessScopeCommandInput} for command's `input` shape.
 * @see {@link CreateNetworkInsightsAccessScopeCommandOutput} for command's `response` shape.
 * @see {@link EC2ClientResolvedConfig | config} for EC2Client's `config` shape.
 *
 */
export declare class CreateNetworkInsightsAccessScopeCommand extends $Command<CreateNetworkInsightsAccessScopeCommandInput, CreateNetworkInsightsAccessScopeCommandOutput, EC2ClientResolvedConfig> {
    readonly input: CreateNetworkInsightsAccessScopeCommandInput;
    constructor(input: CreateNetworkInsightsAccessScopeCommandInput);
    /**
     * @internal
     */
    resolveMiddleware(clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>, configuration: EC2ClientResolvedConfig, options?: __HttpHandlerOptions): Handler<CreateNetworkInsightsAccessScopeCommandInput, CreateNetworkInsightsAccessScopeCommandOutput>;
    private serialize;
    private deserialize;
}
