import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { UpdateSecurityGroupRuleDescriptionsIngressRequest, UpdateSecurityGroupRuleDescriptionsIngressResult, } from "../models/models_6";
import { deserializeAws_ec2UpdateSecurityGroupRuleDescriptionsIngressCommand, serializeAws_ec2UpdateSecurityGroupRuleDescriptionsIngressCommand, } from "../protocols/Aws_ec2";
var UpdateSecurityGroupRuleDescriptionsIngressCommand = (function (_super) {
    __extends(UpdateSecurityGroupRuleDescriptionsIngressCommand, _super);
    function UpdateSecurityGroupRuleDescriptionsIngressCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    UpdateSecurityGroupRuleDescriptionsIngressCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "UpdateSecurityGroupRuleDescriptionsIngressCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: UpdateSecurityGroupRuleDescriptionsIngressRequest.filterSensitiveLog,
            outputFilterSensitiveLog: UpdateSecurityGroupRuleDescriptionsIngressResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    UpdateSecurityGroupRuleDescriptionsIngressCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2UpdateSecurityGroupRuleDescriptionsIngressCommand(input, context);
    };
    UpdateSecurityGroupRuleDescriptionsIngressCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2UpdateSecurityGroupRuleDescriptionsIngressCommand(output, context);
    };
    return UpdateSecurityGroupRuleDescriptionsIngressCommand;
}($Command));
export { UpdateSecurityGroupRuleDescriptionsIngressCommand };
