import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { TerminateInstancesRequest, TerminateInstancesResult } from "../models/models_6";
import { deserializeAws_ec2TerminateInstancesCommand, serializeAws_ec2TerminateInstancesCommand, } from "../protocols/Aws_ec2";
var TerminateInstancesCommand = (function (_super) {
    __extends(TerminateInstancesCommand, _super);
    function TerminateInstancesCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    TerminateInstancesCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "TerminateInstancesCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: TerminateInstancesRequest.filterSensitiveLog,
            outputFilterSensitiveLog: TerminateInstancesResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    TerminateInstancesCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2TerminateInstancesCommand(input, context);
    };
    TerminateInstancesCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2TerminateInstancesCommand(output, context);
    };
    return TerminateInstancesCommand;
}($Command));
export { TerminateInstancesCommand };
