import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { StopInstancesRequest, StopInstancesResult } from "../models/models_6";
import { deserializeAws_ec2StopInstancesCommand, serializeAws_ec2StopInstancesCommand } from "../protocols/Aws_ec2";
var StopInstancesCommand = (function (_super) {
    __extends(StopInstancesCommand, _super);
    function StopInstancesCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    StopInstancesCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "StopInstancesCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: StopInstancesRequest.filterSensitiveLog,
            outputFilterSensitiveLog: StopInstancesResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    StopInstancesCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2StopInstancesCommand(input, context);
    };
    StopInstancesCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2StopInstancesCommand(output, context);
    };
    return StopInstancesCommand;
}($Command));
export { StopInstancesCommand };
