import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { Reservation } from "../models/models_3";
import { RunInstancesRequest } from "../models/models_6";
import { deserializeAws_ec2RunInstancesCommand, serializeAws_ec2RunInstancesCommand } from "../protocols/Aws_ec2";
var RunInstancesCommand = (function (_super) {
    __extends(RunInstancesCommand, _super);
    function RunInstancesCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    RunInstancesCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "RunInstancesCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: RunInstancesRequest.filterSensitiveLog,
            outputFilterSensitiveLog: Reservation.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    RunInstancesCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2RunInstancesCommand(input, context);
    };
    RunInstancesCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2RunInstancesCommand(output, context);
    };
    return RunInstancesCommand;
}($Command));
export { RunInstancesCommand };
