import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { RevokeClientVpnIngressRequest, RevokeClientVpnIngressResult } from "../models/models_5";
import { deserializeAws_ec2RevokeClientVpnIngressCommand, serializeAws_ec2RevokeClientVpnIngressCommand, } from "../protocols/Aws_ec2";
var RevokeClientVpnIngressCommand = (function (_super) {
    __extends(RevokeClientVpnIngressCommand, _super);
    function RevokeClientVpnIngressCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    RevokeClientVpnIngressCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "RevokeClientVpnIngressCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: RevokeClientVpnIngressRequest.filterSensitiveLog,
            outputFilterSensitiveLog: RevokeClientVpnIngressResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    RevokeClientVpnIngressCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2RevokeClientVpnIngressCommand(input, context);
    };
    RevokeClientVpnIngressCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2RevokeClientVpnIngressCommand(output, context);
    };
    return RevokeClientVpnIngressCommand;
}($Command));
export { RevokeClientVpnIngressCommand };
