import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { RestoreAddressToClassicRequest, RestoreAddressToClassicResult } from "../models/models_5";
import { deserializeAws_ec2RestoreAddressToClassicCommand, serializeAws_ec2RestoreAddressToClassicCommand, } from "../protocols/Aws_ec2";
var RestoreAddressToClassicCommand = (function (_super) {
    __extends(RestoreAddressToClassicCommand, _super);
    function RestoreAddressToClassicCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    RestoreAddressToClassicCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "RestoreAddressToClassicCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: RestoreAddressToClassicRequest.filterSensitiveLog,
            outputFilterSensitiveLog: RestoreAddressToClassicResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    RestoreAddressToClassicCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2RestoreAddressToClassicCommand(input, context);
    };
    RestoreAddressToClassicCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2RestoreAddressToClassicCommand(output, context);
    };
    return RestoreAddressToClassicCommand;
}($Command));
export { RestoreAddressToClassicCommand };
