import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { ResetFpgaImageAttributeRequest, ResetFpgaImageAttributeResult } from "../models/models_5";
import { deserializeAws_ec2ResetFpgaImageAttributeCommand, serializeAws_ec2ResetFpgaImageAttributeCommand, } from "../protocols/Aws_ec2";
var ResetFpgaImageAttributeCommand = (function (_super) {
    __extends(ResetFpgaImageAttributeCommand, _super);
    function ResetFpgaImageAttributeCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    ResetFpgaImageAttributeCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "ResetFpgaImageAttributeCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: ResetFpgaImageAttributeRequest.filterSensitiveLog,
            outputFilterSensitiveLog: ResetFpgaImageAttributeResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    ResetFpgaImageAttributeCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2ResetFpgaImageAttributeCommand(input, context);
    };
    ResetFpgaImageAttributeCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2ResetFpgaImageAttributeCommand(output, context);
    };
    return ResetFpgaImageAttributeCommand;
}($Command));
export { ResetFpgaImageAttributeCommand };
