import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { RequestSpotFleetRequest, RequestSpotFleetResponse } from "../models/models_5";
import { deserializeAws_ec2RequestSpotFleetCommand, serializeAws_ec2RequestSpotFleetCommand, } from "../protocols/Aws_ec2";
var RequestSpotFleetCommand = (function (_super) {
    __extends(RequestSpotFleetCommand, _super);
    function RequestSpotFleetCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    RequestSpotFleetCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "RequestSpotFleetCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: RequestSpotFleetRequest.filterSensitiveLog,
            outputFilterSensitiveLog: RequestSpotFleetResponse.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    RequestSpotFleetCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2RequestSpotFleetCommand(input, context);
    };
    RequestSpotFleetCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2RequestSpotFleetCommand(output, context);
    };
    return RequestSpotFleetCommand;
}($Command));
export { RequestSpotFleetCommand };
