import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { ReplaceIamInstanceProfileAssociationRequest, ReplaceIamInstanceProfileAssociationResult, } from "../models/models_5";
import { deserializeAws_ec2ReplaceIamInstanceProfileAssociationCommand, serializeAws_ec2ReplaceIamInstanceProfileAssociationCommand, } from "../protocols/Aws_ec2";
var ReplaceIamInstanceProfileAssociationCommand = (function (_super) {
    __extends(ReplaceIamInstanceProfileAssociationCommand, _super);
    function ReplaceIamInstanceProfileAssociationCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    ReplaceIamInstanceProfileAssociationCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "ReplaceIamInstanceProfileAssociationCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: ReplaceIamInstanceProfileAssociationRequest.filterSensitiveLog,
            outputFilterSensitiveLog: ReplaceIamInstanceProfileAssociationResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    ReplaceIamInstanceProfileAssociationCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2ReplaceIamInstanceProfileAssociationCommand(input, context);
    };
    ReplaceIamInstanceProfileAssociationCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2ReplaceIamInstanceProfileAssociationCommand(output, context);
    };
    return ReplaceIamInstanceProfileAssociationCommand;
}($Command));
export { ReplaceIamInstanceProfileAssociationCommand };
