import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { ReleaseAddressRequest } from "../models/models_5";
import { deserializeAws_ec2ReleaseAddressCommand, serializeAws_ec2ReleaseAddressCommand } from "../protocols/Aws_ec2";
var ReleaseAddressCommand = (function (_super) {
    __extends(ReleaseAddressCommand, _super);
    function ReleaseAddressCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    ReleaseAddressCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "ReleaseAddressCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: ReleaseAddressRequest.filterSensitiveLog,
            outputFilterSensitiveLog: function (output) { return output; },
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    ReleaseAddressCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2ReleaseAddressCommand(input, context);
    };
    ReleaseAddressCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2ReleaseAddressCommand(output, context);
    };
    return ReleaseAddressCommand;
}($Command));
export { ReleaseAddressCommand };
