import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { RejectTransitGatewayVpcAttachmentRequest, RejectTransitGatewayVpcAttachmentResult } from "../models/models_5";
import { deserializeAws_ec2RejectTransitGatewayVpcAttachmentCommand, serializeAws_ec2RejectTransitGatewayVpcAttachmentCommand, } from "../protocols/Aws_ec2";
var RejectTransitGatewayVpcAttachmentCommand = (function (_super) {
    __extends(RejectTransitGatewayVpcAttachmentCommand, _super);
    function RejectTransitGatewayVpcAttachmentCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    RejectTransitGatewayVpcAttachmentCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "RejectTransitGatewayVpcAttachmentCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: RejectTransitGatewayVpcAttachmentRequest.filterSensitiveLog,
            outputFilterSensitiveLog: RejectTransitGatewayVpcAttachmentResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    RejectTransitGatewayVpcAttachmentCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2RejectTransitGatewayVpcAttachmentCommand(input, context);
    };
    RejectTransitGatewayVpcAttachmentCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2RejectTransitGatewayVpcAttachmentCommand(output, context);
    };
    return RejectTransitGatewayVpcAttachmentCommand;
}($Command));
export { RejectTransitGatewayVpcAttachmentCommand };
