import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { RejectTransitGatewayPeeringAttachmentRequest, RejectTransitGatewayPeeringAttachmentResult, } from "../models/models_5";
import { deserializeAws_ec2RejectTransitGatewayPeeringAttachmentCommand, serializeAws_ec2RejectTransitGatewayPeeringAttachmentCommand, } from "../protocols/Aws_ec2";
var RejectTransitGatewayPeeringAttachmentCommand = (function (_super) {
    __extends(RejectTransitGatewayPeeringAttachmentCommand, _super);
    function RejectTransitGatewayPeeringAttachmentCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    RejectTransitGatewayPeeringAttachmentCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "RejectTransitGatewayPeeringAttachmentCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: RejectTransitGatewayPeeringAttachmentRequest.filterSensitiveLog,
            outputFilterSensitiveLog: RejectTransitGatewayPeeringAttachmentResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    RejectTransitGatewayPeeringAttachmentCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2RejectTransitGatewayPeeringAttachmentCommand(input, context);
    };
    RejectTransitGatewayPeeringAttachmentCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2RejectTransitGatewayPeeringAttachmentCommand(output, context);
    };
    return RejectTransitGatewayPeeringAttachmentCommand;
}($Command));
export { RejectTransitGatewayPeeringAttachmentCommand };
