import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { RegisterTransitGatewayMulticastGroupMembersRequest, RegisterTransitGatewayMulticastGroupMembersResult, } from "../models/models_5";
import { deserializeAws_ec2RegisterTransitGatewayMulticastGroupMembersCommand, serializeAws_ec2RegisterTransitGatewayMulticastGroupMembersCommand, } from "../protocols/Aws_ec2";
var RegisterTransitGatewayMulticastGroupMembersCommand = (function (_super) {
    __extends(RegisterTransitGatewayMulticastGroupMembersCommand, _super);
    function RegisterTransitGatewayMulticastGroupMembersCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    RegisterTransitGatewayMulticastGroupMembersCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "RegisterTransitGatewayMulticastGroupMembersCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: RegisterTransitGatewayMulticastGroupMembersRequest.filterSensitiveLog,
            outputFilterSensitiveLog: RegisterTransitGatewayMulticastGroupMembersResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    RegisterTransitGatewayMulticastGroupMembersCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2RegisterTransitGatewayMulticastGroupMembersCommand(input, context);
    };
    RegisterTransitGatewayMulticastGroupMembersCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2RegisterTransitGatewayMulticastGroupMembersCommand(output, context);
    };
    return RegisterTransitGatewayMulticastGroupMembersCommand;
}($Command));
export { RegisterTransitGatewayMulticastGroupMembersCommand };
