import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { RegisterImageRequest, RegisterImageResult } from "../models/models_5";
import { deserializeAws_ec2RegisterImageCommand, serializeAws_ec2RegisterImageCommand } from "../protocols/Aws_ec2";
var RegisterImageCommand = (function (_super) {
    __extends(RegisterImageCommand, _super);
    function RegisterImageCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    RegisterImageCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "RegisterImageCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: RegisterImageRequest.filterSensitiveLog,
            outputFilterSensitiveLog: RegisterImageResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    RegisterImageCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2RegisterImageCommand(input, context);
    };
    RegisterImageCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2RegisterImageCommand(output, context);
    };
    return RegisterImageCommand;
}($Command));
export { RegisterImageCommand };
