import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { PurchaseReservedInstancesOfferingRequest, PurchaseReservedInstancesOfferingResult } from "../models/models_5";
import { deserializeAws_ec2PurchaseReservedInstancesOfferingCommand, serializeAws_ec2PurchaseReservedInstancesOfferingCommand, } from "../protocols/Aws_ec2";
var PurchaseReservedInstancesOfferingCommand = (function (_super) {
    __extends(PurchaseReservedInstancesOfferingCommand, _super);
    function PurchaseReservedInstancesOfferingCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    PurchaseReservedInstancesOfferingCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "PurchaseReservedInstancesOfferingCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: PurchaseReservedInstancesOfferingRequest.filterSensitiveLog,
            outputFilterSensitiveLog: PurchaseReservedInstancesOfferingResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    PurchaseReservedInstancesOfferingCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2PurchaseReservedInstancesOfferingCommand(input, context);
    };
    PurchaseReservedInstancesOfferingCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2PurchaseReservedInstancesOfferingCommand(output, context);
    };
    return PurchaseReservedInstancesOfferingCommand;
}($Command));
export { PurchaseReservedInstancesOfferingCommand };
