import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { ProvisionPublicIpv4PoolCidrRequest, ProvisionPublicIpv4PoolCidrResult } from "../models/models_5";
import { deserializeAws_ec2ProvisionPublicIpv4PoolCidrCommand, serializeAws_ec2ProvisionPublicIpv4PoolCidrCommand, } from "../protocols/Aws_ec2";
var ProvisionPublicIpv4PoolCidrCommand = (function (_super) {
    __extends(ProvisionPublicIpv4PoolCidrCommand, _super);
    function ProvisionPublicIpv4PoolCidrCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    ProvisionPublicIpv4PoolCidrCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "ProvisionPublicIpv4PoolCidrCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: ProvisionPublicIpv4PoolCidrRequest.filterSensitiveLog,
            outputFilterSensitiveLog: ProvisionPublicIpv4PoolCidrResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    ProvisionPublicIpv4PoolCidrCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2ProvisionPublicIpv4PoolCidrCommand(input, context);
    };
    ProvisionPublicIpv4PoolCidrCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2ProvisionPublicIpv4PoolCidrCommand(output, context);
    };
    return ProvisionPublicIpv4PoolCidrCommand;
}($Command));
export { ProvisionPublicIpv4PoolCidrCommand };
