import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { ModifyVpnConnectionOptionsRequest, ModifyVpnConnectionOptionsResult } from "../models/models_5";
import { deserializeAws_ec2ModifyVpnConnectionOptionsCommand, serializeAws_ec2ModifyVpnConnectionOptionsCommand, } from "../protocols/Aws_ec2";
var ModifyVpnConnectionOptionsCommand = (function (_super) {
    __extends(ModifyVpnConnectionOptionsCommand, _super);
    function ModifyVpnConnectionOptionsCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    ModifyVpnConnectionOptionsCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "ModifyVpnConnectionOptionsCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: ModifyVpnConnectionOptionsRequest.filterSensitiveLog,
            outputFilterSensitiveLog: ModifyVpnConnectionOptionsResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    ModifyVpnConnectionOptionsCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2ModifyVpnConnectionOptionsCommand(input, context);
    };
    ModifyVpnConnectionOptionsCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2ModifyVpnConnectionOptionsCommand(output, context);
    };
    return ModifyVpnConnectionOptionsCommand;
}($Command));
export { ModifyVpnConnectionOptionsCommand };
