import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { ModifyVpcEndpointServicePermissionsRequest, ModifyVpcEndpointServicePermissionsResult, } from "../models/models_5";
import { deserializeAws_ec2ModifyVpcEndpointServicePermissionsCommand, serializeAws_ec2ModifyVpcEndpointServicePermissionsCommand, } from "../protocols/Aws_ec2";
var ModifyVpcEndpointServicePermissionsCommand = (function (_super) {
    __extends(ModifyVpcEndpointServicePermissionsCommand, _super);
    function ModifyVpcEndpointServicePermissionsCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    ModifyVpcEndpointServicePermissionsCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "ModifyVpcEndpointServicePermissionsCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: ModifyVpcEndpointServicePermissionsRequest.filterSensitiveLog,
            outputFilterSensitiveLog: ModifyVpcEndpointServicePermissionsResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    ModifyVpcEndpointServicePermissionsCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2ModifyVpcEndpointServicePermissionsCommand(input, context);
    };
    ModifyVpcEndpointServicePermissionsCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2ModifyVpcEndpointServicePermissionsCommand(output, context);
    };
    return ModifyVpcEndpointServicePermissionsCommand;
}($Command));
export { ModifyVpcEndpointServicePermissionsCommand };
