import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { ModifyVpcEndpointServiceConfigurationRequest, ModifyVpcEndpointServiceConfigurationResult, } from "../models/models_5";
import { deserializeAws_ec2ModifyVpcEndpointServiceConfigurationCommand, serializeAws_ec2ModifyVpcEndpointServiceConfigurationCommand, } from "../protocols/Aws_ec2";
var ModifyVpcEndpointServiceConfigurationCommand = (function (_super) {
    __extends(ModifyVpcEndpointServiceConfigurationCommand, _super);
    function ModifyVpcEndpointServiceConfigurationCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    ModifyVpcEndpointServiceConfigurationCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "ModifyVpcEndpointServiceConfigurationCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: ModifyVpcEndpointServiceConfigurationRequest.filterSensitiveLog,
            outputFilterSensitiveLog: ModifyVpcEndpointServiceConfigurationResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    ModifyVpcEndpointServiceConfigurationCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2ModifyVpcEndpointServiceConfigurationCommand(input, context);
    };
    ModifyVpcEndpointServiceConfigurationCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2ModifyVpcEndpointServiceConfigurationCommand(output, context);
    };
    return ModifyVpcEndpointServiceConfigurationCommand;
}($Command));
export { ModifyVpcEndpointServiceConfigurationCommand };
