import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { ModifyVpcAttributeRequest } from "../models/models_5";
import { deserializeAws_ec2ModifyVpcAttributeCommand, serializeAws_ec2ModifyVpcAttributeCommand, } from "../protocols/Aws_ec2";
var ModifyVpcAttributeCommand = (function (_super) {
    __extends(ModifyVpcAttributeCommand, _super);
    function ModifyVpcAttributeCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    ModifyVpcAttributeCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "ModifyVpcAttributeCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: ModifyVpcAttributeRequest.filterSensitiveLog,
            outputFilterSensitiveLog: function (output) { return output; },
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    ModifyVpcAttributeCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2ModifyVpcAttributeCommand(input, context);
    };
    ModifyVpcAttributeCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2ModifyVpcAttributeCommand(output, context);
    };
    return ModifyVpcAttributeCommand;
}($Command));
export { ModifyVpcAttributeCommand };
