import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { ModifyTrafficMirrorSessionRequest, ModifyTrafficMirrorSessionResult } from "../models/models_5";
import { deserializeAws_ec2ModifyTrafficMirrorSessionCommand, serializeAws_ec2ModifyTrafficMirrorSessionCommand, } from "../protocols/Aws_ec2";
var ModifyTrafficMirrorSessionCommand = (function (_super) {
    __extends(ModifyTrafficMirrorSessionCommand, _super);
    function ModifyTrafficMirrorSessionCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    ModifyTrafficMirrorSessionCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "ModifyTrafficMirrorSessionCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: ModifyTrafficMirrorSessionRequest.filterSensitiveLog,
            outputFilterSensitiveLog: ModifyTrafficMirrorSessionResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    ModifyTrafficMirrorSessionCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2ModifyTrafficMirrorSessionCommand(input, context);
    };
    ModifyTrafficMirrorSessionCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2ModifyTrafficMirrorSessionCommand(output, context);
    };
    return ModifyTrafficMirrorSessionCommand;
}($Command));
export { ModifyTrafficMirrorSessionCommand };
