import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { ModifySnapshotTierRequest, ModifySnapshotTierResult } from "../models/models_5";
import { deserializeAws_ec2ModifySnapshotTierCommand, serializeAws_ec2ModifySnapshotTierCommand, } from "../protocols/Aws_ec2";
var ModifySnapshotTierCommand = (function (_super) {
    __extends(ModifySnapshotTierCommand, _super);
    function ModifySnapshotTierCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    ModifySnapshotTierCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "ModifySnapshotTierCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: ModifySnapshotTierRequest.filterSensitiveLog,
            outputFilterSensitiveLog: ModifySnapshotTierResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    ModifySnapshotTierCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2ModifySnapshotTierCommand(input, context);
    };
    ModifySnapshotTierCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2ModifySnapshotTierCommand(output, context);
    };
    return ModifySnapshotTierCommand;
}($Command));
export { ModifySnapshotTierCommand };
