import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { ModifySnapshotAttributeRequest } from "../models/models_5";
import { deserializeAws_ec2ModifySnapshotAttributeCommand, serializeAws_ec2ModifySnapshotAttributeCommand, } from "../protocols/Aws_ec2";
var ModifySnapshotAttributeCommand = (function (_super) {
    __extends(ModifySnapshotAttributeCommand, _super);
    function ModifySnapshotAttributeCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    ModifySnapshotAttributeCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "ModifySnapshotAttributeCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: ModifySnapshotAttributeRequest.filterSensitiveLog,
            outputFilterSensitiveLog: function (output) { return output; },
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    ModifySnapshotAttributeCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2ModifySnapshotAttributeCommand(input, context);
    };
    ModifySnapshotAttributeCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2ModifySnapshotAttributeCommand(output, context);
    };
    return ModifySnapshotAttributeCommand;
}($Command));
export { ModifySnapshotAttributeCommand };
