import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { ModifyNetworkInterfaceAttributeRequest } from "../models/models_5";
import { deserializeAws_ec2ModifyNetworkInterfaceAttributeCommand, serializeAws_ec2ModifyNetworkInterfaceAttributeCommand, } from "../protocols/Aws_ec2";
var ModifyNetworkInterfaceAttributeCommand = (function (_super) {
    __extends(ModifyNetworkInterfaceAttributeCommand, _super);
    function ModifyNetworkInterfaceAttributeCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    ModifyNetworkInterfaceAttributeCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "ModifyNetworkInterfaceAttributeCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: ModifyNetworkInterfaceAttributeRequest.filterSensitiveLog,
            outputFilterSensitiveLog: function (output) { return output; },
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    ModifyNetworkInterfaceAttributeCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2ModifyNetworkInterfaceAttributeCommand(input, context);
    };
    ModifyNetworkInterfaceAttributeCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2ModifyNetworkInterfaceAttributeCommand(output, context);
    };
    return ModifyNetworkInterfaceAttributeCommand;
}($Command));
export { ModifyNetworkInterfaceAttributeCommand };
