import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { ModifyManagedPrefixListRequest, ModifyManagedPrefixListResult } from "../models/models_5";
import { deserializeAws_ec2ModifyManagedPrefixListCommand, serializeAws_ec2ModifyManagedPrefixListCommand, } from "../protocols/Aws_ec2";
var ModifyManagedPrefixListCommand = (function (_super) {
    __extends(ModifyManagedPrefixListCommand, _super);
    function ModifyManagedPrefixListCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    ModifyManagedPrefixListCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "ModifyManagedPrefixListCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: ModifyManagedPrefixListRequest.filterSensitiveLog,
            outputFilterSensitiveLog: ModifyManagedPrefixListResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    ModifyManagedPrefixListCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2ModifyManagedPrefixListCommand(input, context);
    };
    ModifyManagedPrefixListCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2ModifyManagedPrefixListCommand(output, context);
    };
    return ModifyManagedPrefixListCommand;
}($Command));
export { ModifyManagedPrefixListCommand };
