import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { ModifyLaunchTemplateRequest, ModifyLaunchTemplateResult } from "../models/models_5";
import { deserializeAws_ec2ModifyLaunchTemplateCommand, serializeAws_ec2ModifyLaunchTemplateCommand, } from "../protocols/Aws_ec2";
var ModifyLaunchTemplateCommand = (function (_super) {
    __extends(ModifyLaunchTemplateCommand, _super);
    function ModifyLaunchTemplateCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    ModifyLaunchTemplateCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "ModifyLaunchTemplateCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: ModifyLaunchTemplateRequest.filterSensitiveLog,
            outputFilterSensitiveLog: ModifyLaunchTemplateResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    ModifyLaunchTemplateCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2ModifyLaunchTemplateCommand(input, context);
    };
    ModifyLaunchTemplateCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2ModifyLaunchTemplateCommand(output, context);
    };
    return ModifyLaunchTemplateCommand;
}($Command));
export { ModifyLaunchTemplateCommand };
