import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { ModifyIpamScopeRequest, ModifyIpamScopeResult } from "../models/models_5";
import { deserializeAws_ec2ModifyIpamScopeCommand, serializeAws_ec2ModifyIpamScopeCommand } from "../protocols/Aws_ec2";
var ModifyIpamScopeCommand = (function (_super) {
    __extends(ModifyIpamScopeCommand, _super);
    function ModifyIpamScopeCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    ModifyIpamScopeCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "ModifyIpamScopeCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: ModifyIpamScopeRequest.filterSensitiveLog,
            outputFilterSensitiveLog: ModifyIpamScopeResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    ModifyIpamScopeCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2ModifyIpamScopeCommand(input, context);
    };
    ModifyIpamScopeCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2ModifyIpamScopeCommand(output, context);
    };
    return ModifyIpamScopeCommand;
}($Command));
export { ModifyIpamScopeCommand };
