import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { ModifyInstanceEventWindowRequest, ModifyInstanceEventWindowResult } from "../models/models_5";
import { deserializeAws_ec2ModifyInstanceEventWindowCommand, serializeAws_ec2ModifyInstanceEventWindowCommand, } from "../protocols/Aws_ec2";
var ModifyInstanceEventWindowCommand = (function (_super) {
    __extends(ModifyInstanceEventWindowCommand, _super);
    function ModifyInstanceEventWindowCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    ModifyInstanceEventWindowCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "ModifyInstanceEventWindowCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: ModifyInstanceEventWindowRequest.filterSensitiveLog,
            outputFilterSensitiveLog: ModifyInstanceEventWindowResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    ModifyInstanceEventWindowCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2ModifyInstanceEventWindowCommand(input, context);
    };
    ModifyInstanceEventWindowCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2ModifyInstanceEventWindowCommand(output, context);
    };
    return ModifyInstanceEventWindowCommand;
}($Command));
export { ModifyInstanceEventWindowCommand };
