import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { ModifyInstanceEventStartTimeRequest, ModifyInstanceEventStartTimeResult } from "../models/models_5";
import { deserializeAws_ec2ModifyInstanceEventStartTimeCommand, serializeAws_ec2ModifyInstanceEventStartTimeCommand, } from "../protocols/Aws_ec2";
var ModifyInstanceEventStartTimeCommand = (function (_super) {
    __extends(ModifyInstanceEventStartTimeCommand, _super);
    function ModifyInstanceEventStartTimeCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    ModifyInstanceEventStartTimeCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "ModifyInstanceEventStartTimeCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: ModifyInstanceEventStartTimeRequest.filterSensitiveLog,
            outputFilterSensitiveLog: ModifyInstanceEventStartTimeResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    ModifyInstanceEventStartTimeCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2ModifyInstanceEventStartTimeCommand(input, context);
    };
    ModifyInstanceEventStartTimeCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2ModifyInstanceEventStartTimeCommand(output, context);
    };
    return ModifyInstanceEventStartTimeCommand;
}($Command));
export { ModifyInstanceEventStartTimeCommand };
