import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { ModifyInstanceAttributeRequest } from "../models/models_5";
import { deserializeAws_ec2ModifyInstanceAttributeCommand, serializeAws_ec2ModifyInstanceAttributeCommand, } from "../protocols/Aws_ec2";
var ModifyInstanceAttributeCommand = (function (_super) {
    __extends(ModifyInstanceAttributeCommand, _super);
    function ModifyInstanceAttributeCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    ModifyInstanceAttributeCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "ModifyInstanceAttributeCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: ModifyInstanceAttributeRequest.filterSensitiveLog,
            outputFilterSensitiveLog: function (output) { return output; },
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    ModifyInstanceAttributeCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2ModifyInstanceAttributeCommand(input, context);
    };
    ModifyInstanceAttributeCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2ModifyInstanceAttributeCommand(output, context);
    };
    return ModifyInstanceAttributeCommand;
}($Command));
export { ModifyInstanceAttributeCommand };
