import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { ModifyFpgaImageAttributeRequest, ModifyFpgaImageAttributeResult } from "../models/models_5";
import { deserializeAws_ec2ModifyFpgaImageAttributeCommand, serializeAws_ec2ModifyFpgaImageAttributeCommand, } from "../protocols/Aws_ec2";
var ModifyFpgaImageAttributeCommand = (function (_super) {
    __extends(ModifyFpgaImageAttributeCommand, _super);
    function ModifyFpgaImageAttributeCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    ModifyFpgaImageAttributeCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "ModifyFpgaImageAttributeCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: ModifyFpgaImageAttributeRequest.filterSensitiveLog,
            outputFilterSensitiveLog: ModifyFpgaImageAttributeResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    ModifyFpgaImageAttributeCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2ModifyFpgaImageAttributeCommand(input, context);
    };
    ModifyFpgaImageAttributeCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2ModifyFpgaImageAttributeCommand(output, context);
    };
    return ModifyFpgaImageAttributeCommand;
}($Command));
export { ModifyFpgaImageAttributeCommand };
