import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { ModifyFleetRequest, ModifyFleetResult } from "../models/models_5";
import { deserializeAws_ec2ModifyFleetCommand, serializeAws_ec2ModifyFleetCommand } from "../protocols/Aws_ec2";
var ModifyFleetCommand = (function (_super) {
    __extends(ModifyFleetCommand, _super);
    function ModifyFleetCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    ModifyFleetCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "ModifyFleetCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: ModifyFleetRequest.filterSensitiveLog,
            outputFilterSensitiveLog: ModifyFleetResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    ModifyFleetCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2ModifyFleetCommand(input, context);
    };
    ModifyFleetCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2ModifyFleetCommand(output, context);
    };
    return ModifyFleetCommand;
}($Command));
export { ModifyFleetCommand };
