import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { ModifyDefaultCreditSpecificationRequest, ModifyDefaultCreditSpecificationResult } from "../models/models_5";
import { deserializeAws_ec2ModifyDefaultCreditSpecificationCommand, serializeAws_ec2ModifyDefaultCreditSpecificationCommand, } from "../protocols/Aws_ec2";
var ModifyDefaultCreditSpecificationCommand = (function (_super) {
    __extends(ModifyDefaultCreditSpecificationCommand, _super);
    function ModifyDefaultCreditSpecificationCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    ModifyDefaultCreditSpecificationCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "ModifyDefaultCreditSpecificationCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: ModifyDefaultCreditSpecificationRequest.filterSensitiveLog,
            outputFilterSensitiveLog: ModifyDefaultCreditSpecificationResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    ModifyDefaultCreditSpecificationCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2ModifyDefaultCreditSpecificationCommand(input, context);
    };
    ModifyDefaultCreditSpecificationCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2ModifyDefaultCreditSpecificationCommand(output, context);
    };
    return ModifyDefaultCreditSpecificationCommand;
}($Command));
export { ModifyDefaultCreditSpecificationCommand };
