import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { ModifyCapacityReservationFleetRequest, ModifyCapacityReservationFleetResult } from "../models/models_5";
import { deserializeAws_ec2ModifyCapacityReservationFleetCommand, serializeAws_ec2ModifyCapacityReservationFleetCommand, } from "../protocols/Aws_ec2";
var ModifyCapacityReservationFleetCommand = (function (_super) {
    __extends(ModifyCapacityReservationFleetCommand, _super);
    function ModifyCapacityReservationFleetCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    ModifyCapacityReservationFleetCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "ModifyCapacityReservationFleetCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: ModifyCapacityReservationFleetRequest.filterSensitiveLog,
            outputFilterSensitiveLog: ModifyCapacityReservationFleetResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    ModifyCapacityReservationFleetCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2ModifyCapacityReservationFleetCommand(input, context);
    };
    ModifyCapacityReservationFleetCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2ModifyCapacityReservationFleetCommand(output, context);
    };
    return ModifyCapacityReservationFleetCommand;
}($Command));
export { ModifyCapacityReservationFleetCommand };
