import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { ModifyAvailabilityZoneGroupRequest, ModifyAvailabilityZoneGroupResult } from "../models/models_5";
import { deserializeAws_ec2ModifyAvailabilityZoneGroupCommand, serializeAws_ec2ModifyAvailabilityZoneGroupCommand, } from "../protocols/Aws_ec2";
var ModifyAvailabilityZoneGroupCommand = (function (_super) {
    __extends(ModifyAvailabilityZoneGroupCommand, _super);
    function ModifyAvailabilityZoneGroupCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    ModifyAvailabilityZoneGroupCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "ModifyAvailabilityZoneGroupCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: ModifyAvailabilityZoneGroupRequest.filterSensitiveLog,
            outputFilterSensitiveLog: ModifyAvailabilityZoneGroupResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    ModifyAvailabilityZoneGroupCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2ModifyAvailabilityZoneGroupCommand(input, context);
    };
    ModifyAvailabilityZoneGroupCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2ModifyAvailabilityZoneGroupCommand(output, context);
    };
    return ModifyAvailabilityZoneGroupCommand;
}($Command));
export { ModifyAvailabilityZoneGroupCommand };
