import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { ImportVolumeRequest, ImportVolumeResult } from "../models/models_5";
import { deserializeAws_ec2ImportVolumeCommand, serializeAws_ec2ImportVolumeCommand } from "../protocols/Aws_ec2";
var ImportVolumeCommand = (function (_super) {
    __extends(ImportVolumeCommand, _super);
    function ImportVolumeCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    ImportVolumeCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "ImportVolumeCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: ImportVolumeRequest.filterSensitiveLog,
            outputFilterSensitiveLog: ImportVolumeResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    ImportVolumeCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2ImportVolumeCommand(input, context);
    };
    ImportVolumeCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2ImportVolumeCommand(output, context);
    };
    return ImportVolumeCommand;
}($Command));
export { ImportVolumeCommand };
