import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { GetVpnConnectionDeviceSampleConfigurationRequest, GetVpnConnectionDeviceSampleConfigurationResult, } from "../models/models_5";
import { deserializeAws_ec2GetVpnConnectionDeviceSampleConfigurationCommand, serializeAws_ec2GetVpnConnectionDeviceSampleConfigurationCommand, } from "../protocols/Aws_ec2";
var GetVpnConnectionDeviceSampleConfigurationCommand = (function (_super) {
    __extends(GetVpnConnectionDeviceSampleConfigurationCommand, _super);
    function GetVpnConnectionDeviceSampleConfigurationCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    GetVpnConnectionDeviceSampleConfigurationCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "EC2Client";
        var commandName = "GetVpnConnectionDeviceSampleConfigurationCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: GetVpnConnectionDeviceSampleConfigurationRequest.filterSensitiveLog,
            outputFilterSensitiveLog: GetVpnConnectionDeviceSampleConfigurationResult.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    GetVpnConnectionDeviceSampleConfigurationCommand.prototype.serialize = function (input, context) {
        return serializeAws_ec2GetVpnConnectionDeviceSampleConfigurationCommand(input, context);
    };
    GetVpnConnectionDeviceSampleConfigurationCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_ec2GetVpnConnectionDeviceSampleConfigurationCommand(output, context);
    };
    return GetVpnConnectionDeviceSampleConfigurationCommand;
}($Command));
export { GetVpnConnectionDeviceSampleConfigurationCommand };
